/**
 * LICENSE GUARD - Kritik işlemlerde kullanılır
 * API route'larda import edip çağır
 */

import { NextResponse } from 'next/server'
import { validateLicense } from './license'

/**
 * API route'larda kullan
 * Eğer license geçersizse 403 döner
 */
export async function checkLicense(domain?: string): Promise<NextResponse | null> {
  const isValid = await validateLicense(domain)
  
  if (!isValid) {
    return NextResponse.json(
      { 
        error: 'Invalid License',
        message: 'Bu yazılım yetkisiz kullanımda. Lisans doğrulanamadı.',
        code: 'LICENSE_INVALID'
      },
      { status: 403 }
    )
  }
  
  return null // License geçerli, işleme devam et
}

/**
 * Wrapper function - API route başında kullan
 */
export async function withLicenseCheck(
  handler: Function,
  ...args: any[]
) {
  const licenseError = await checkLicense()
  
  if (licenseError) {
    return licenseError
  }
  
  return handler(...args)
}





