'use client'

import { useEffect, useState } from 'react'
import BlogCard from './BlogCard'
import { BookOpen } from 'lucide-react'

export default function FeaturedBlogs() {
  const [posts, setPosts] = useState<any[]>([])
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    loadPosts()
  }, [])

  const loadPosts = async () => {
    try {
      const res = await fetch('/api/blog?limit=4')
      if (res.ok) {
        const data = await res.json()
        setPosts(data.posts || [])
      }
    } catch (error) {
      console.error('Blog yazıları yüklenirken hata:', error)
    } finally {
      setLoading(false)
    }
  }

  // Eğer blog yoksa hiç gösterme
  if (loading || posts.length === 0) {
    return null
  }

  return (
    <div className="py-16 relative">
      <div className="container mx-auto px-4">
        <div className="flex items-center justify-between mb-8">
          <div className="flex items-center space-x-3">
            <BookOpen className="h-8 w-8 text-green-400" />
            <h2 className="text-3xl font-bold gradient-text">Blog & İçerikler</h2>
          </div>
          <a href="/blog" className="text-sm text-green-400 hover:text-green-300 transition-colors font-semibold">
            Tümünü Gör →
          </a>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {posts.map((post) => (
            <BlogCard key={post.id} post={{
              ...post,
              date: post.createdAt,
              readTime: '5 dakika',
              comments: 0
            }} />
          ))}
        </div>
      </div>
    </div>
  )
}

