import { NextRequest, NextResponse } from 'next/server'
import { prisma } from '@/lib/db'

// GET - Yayınlanmış blog yazılarını listele (public)
export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url)
    const limit = parseInt(searchParams.get('limit') || '10')
    const featured = searchParams.get('featured') === 'true'

    const where: any = {
      published: true,
    }

    const posts = await prisma.blogPost.findMany({
      where,
      orderBy: {
        publishedAt: 'desc',
      },
      take: limit,
    })

    return NextResponse.json({ posts })
  } catch (error) {
    console.error('Blog yazıları yüklenirken hata:', error)
    return NextResponse.json(
      { error: 'Blog yazıları yüklenemedi', posts: [] },
      { status: 500 }
    )
  }
}



