import { NextRequest, NextResponse } from 'next/server'
import { prisma } from '@/lib/db'

export async function POST(request: NextRequest) {
  try {
    const { email } = await request.json()

    if (!email) {
      return NextResponse.json(
        { error: 'E-posta adresi gereklidir' },
        { status: 400 }
      )
    }

    // Kullanıcıyı bul
    const user = await prisma.user.findUnique({
      where: { email },
    })

    // Güvenlik: Kullanıcı var mı yok mu bilgisini verme
    // Her durumda başarılı mesajı döndür
    if (user) {
      // Burada normalde e-posta gönderilir
      // Şimdilik sadece log'a yazıyoruz
      console.log(`Şifre sıfırlama isteği: ${email}`)
      
      // TODO: E-posta gönderme servisi entegrasyonu
      // await sendPasswordResetEmail(user.email, resetToken)
    }

    // Güvenlik nedeniyle her zaman başarılı mesaj döndür
    return NextResponse.json({
      message: 'E-posta adresinize şifre sıfırlama bağlantısı gönderildi',
    })
  } catch (error: any) {
    console.error('Şifre sıfırlama hatası:', error)
    return NextResponse.json(
      { error: 'Bir hata oluştu. Lütfen tekrar deneyin.' },
      { status: 500 }
    )
  }
}
