import Script from 'next/script'

export default function WidgetTestPage() {
  return (
    <>
      <div className="container mx-auto p-8">
        <h1 className="text-3xl font-bold mb-8 text-white">API Sports Widget Test</h1>
        
        <div className="bg-gray-900 rounded-lg shadow-lg p-6 min-h-[600px]">
          <api-sports-widget 
            data-type="games"
            data-tab="live"
          />

          <api-sports-widget 
            data-type="config"
            data-key="303a19f14f12a119e136c61bdf8262ea"
            data-sport="football"
            data-lang="en"
            data-theme="grey"
            data-show-errors="true"
          />
        </div>
      </div>

      <Script 
        src="https://widgets.api-sports.io/2.0/widgets.js"
        strategy="lazyOnload"
      />
    </>
  )
}

