'use client'

import { useEffect } from 'react'

export default function MobilSkorlarPage() {
  useEffect(() => {
    // Widget script'i dinamik olarak yükle
    const script = document.createElement('script')
    script.type = 'module'
    script.src = 'https://widgets.api-sports.io/3.1.0/widgets.js'
    script.async = true
    
    script.onload = () => {
      console.log('✅ Widget script loaded successfully')
    }
    
    script.onerror = (error) => {
      console.error('❌ Widget script failed to load:', error)
    }
    
    document.head.appendChild(script)

    return () => {
      if (document.head.contains(script)) {
        document.head.removeChild(script)
      }
    }
  }, [])

  return (
    <div className="min-h-screen bg-[#2a2a2a]">
      {/* Config Widget */}
      <api-sports-widget
        data-type="config"
        data-key="303a19f14f12a119e136c61bdf8262ea"
        data-sport="football"
      />

      {/* Games Widget - Live Tab */}
      <api-sports-widget 
        data-type="games"
        data-tab="live"
        data-refresh="15"
      />
    </div>
  )
}
