import { Metadata } from 'next'

export const metadata: Metadata = {
  title: 'İddaa Kupon Önerileri - Bugünkü Maç Tahminleri | Banko Kuponlar',
  description: 'Güncel iddaa kupon önerileri, bugünkü maç tahminleri ve banko iddaa kuponları. Yüksek oranlı tahminler, analizli kuponlar ve ücretsiz iddaa tahminleri. Profesyonel tahminciların kuponlarını inceleyin.',
  keywords: 'iddaa kupon önerileri, bugünkü maç tahminleri, banko kuponlar, yüksek oranlı kupon, iddaa tahminleri, güncel kuponlar, haftalık kupon önerileri',
  openGraph: {
    title: 'İddaa Kupon Önerileri - Bugünkü Maç Tahminleri',
    description: 'Güncel iddaa kupon önerileri ve banko tahminler',
    url: 'https://iddaasohbet.com/kuponlar',
  },
  alternates: {
    canonical: 'https://iddaasohbet.com/kuponlar',
  },
}

export default function KuponlarLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return <>{children}</>
}



