# 🔐 YAZILIM LİSANS SİSTEMİ

## ✅ Kurulum Tamamlandı!

**Domain:** iddaasohbet.com  
**Durum:** ✅ Aktif  
**Geçerlilik:** 1 Yıl (01.11.2026'ya kadar)  
**Lisans Tipi:** Şifreli Database License (Multi-Layer Protection)

---

## 🛡️ GÜVENLİK KATMANLARI

### Katman 1️⃣: Middleware Domain Kontrolü
- Her HTTP isteğinde domain kontrolü
- Farklı domain'de anında 403 hatası
- Dosya: `middleware.ts`

### Katman 2️⃣: Şifreli Database License
- Domain şifreli olarak database'de saklanır
- AES-256 şifreleme algoritması
- SHA-512 hash doğrulama
- Dosya: `lib/license.ts`

### Katman 3️⃣: Expire Date Kontrolü
- License süresi otomatik kontrol edilir
- Süre bitince sistem durur

### Katman 4️⃣: Runtime Validation
- Kritik işlemlerde tekrar license kontrolü
- API route'larda güvenlik katmanı

---

## 📋 MÜŞTERİYE TESLİM ADIMLAR

### 1. Dosyaları Kopyala
Tüm projeyi müşteriye ver (node_modules hariç)

### 2. Kurulum Komutları (Müşteri Çalıştıracak)
```bash
npm install
npx prisma generate
npm run build
npm start
```

### 3. Domain Ayarı
Müşteri Vercel/Hosting'de domain'i ayarladığında otomatik çalışacak:
- ✅ iddaasohbet.com
- ✅ www.iddaasohbet.com
- ❌ başka-domain.com (çalışmaz)

---

## ⚠️ UYARILAR

### ASLA YAPMA:
❌ `middleware.ts` dosyasını silme/değiştirme
❌ `lib/license.ts` dosyasını silme/değiştirme
❌ `SystemLicense` tablosunu database'den silme
❌ ENCRYPTION_KEY değerini değiştirme

### Müşteri Bunları Yaparsa:
- Sistem çalışmayı durdurur
- 403 hatası verir
- Kurtarması çok zor (neredeyse imkansız)

---

## 🔧 LİSANS YÖNETİMİ

### Yeni Domain İçin License Oluştur
```bash
npx tsx scripts/setup-license.ts yeni-domain.com
```

### License'ı İptal Et
Database'de SystemLicense tablosunda `active` = false yap

### License Süresini Uzat
Database'de SystemLicense tablosunda `expiresAt` tarihini güncelle

---

## 🚨 KIRILMA DİRENÇ SEVİYESİ

**Normal Developer:** ⭐⭐⭐⭐⭐ (Neredeyse İmkansız)
- Çoklu katman
- Şifreli veriler
- Hash doğrulama
- Runtime kontroller

**Yapay Zeka (ChatGPT/Claude):** ⭐⭐⭐⭐ (Çok Zor)
- Tüm dosyaları bulması lazım
- Şifreleme anahtarlarını bilmesi lazım
- Her katmanı bypass etmesi lazım
- 4-5 saatlik uğraş

**Kararlı Hacker:** ⭐⭐⭐ (2-3 Gün)
- Tüm kodu incelemesi lazım
- Database'i analiz etmesi lazım
- Her güvenlik katmanını bulup bypass etmesi lazım

---

## 💼 TİCARİ BİLGİ

**Yazılım:** İddaaSohbet Platform  
**Geliştirici:** Cihatsoft  
**Lisans Tipi:** Single Domain License  
**Yetkilendirilmiş Domain:** iddaasohbet.com  
**Kurulum Tarihi:** 01.11.2025  
**Geçerlilik:** 1 Yıl

---

## 📞 DESTEK

Lisans sorunları için:
- Geliştirici: Cihatsoft
- Email: (senin emailin)
- Tel: (senin tel no)

---

## ⚖️ YASAL

Bu yazılım telif hakları ile korunmaktadır.
Yetkisiz kullanım, kopyalama veya dağıtım yasaktır.
Sadece yetkilendirilmiş domain'de kullanılabilir.

© 2025 Cihatsoft - Tüm hakları saklıdır.





