"use strict";

const { REST_VERSION } = require("../Constants");

module.exports.BASE_URL = "/api/v" + REST_VERSION;
module.exports.CDN_URL = "https://cdn.discordapp.com";
module.exports.CLIENT_URL = "https://discord.com";

module.exports.AUTO_MODERATION_RULE =                          (guildID, ruleID) => `/guilds/${guildID}/auto-moderation/rules/${ruleID}`;
module.exports.AUTO_MODERATION_RULES =                                 (guildID) => `/guilds/${guildID}/auto-moderation/rules`;
module.exports.COMMAND =                              (applicationID, commandID) => `/applications/${applicationID}/commands/${commandID}`;
module.exports.COMMAND_PERMISSIONS =         (applicationID, guildID, commandID) => `/applications/${applicationID}/guilds/${guildID}/commands/${commandID}/permissions`;
module.exports.COMMANDS =                                        (applicationID) => `/applications/${applicationID}/commands`;
module.exports.CHANNEL =                                                (chanID) => `/channels/${chanID}`;
module.exports.CHANNEL_BULK_DELETE =                                    (chanID) => `/channels/${chanID}/messages/bulk-delete`;
module.exports.CHANNEL_CROSSPOST =                               (chanID, msgID) => `/channels/${chanID}/messages/${msgID}/crosspost`;
module.exports.CHANNEL_FOLLOW =                                         (chanID) => `/channels/${chanID}/followers`;
module.exports.CHANNEL_INVITES =                                        (chanID) => `/channels/${chanID}/invites`;
module.exports.CHANNEL_MESSAGE_REACTION =              (chanID, msgID, reaction) => `/channels/${chanID}/messages/${msgID}/reactions/${reaction}`;
module.exports.CHANNEL_MESSAGE_REACTION_USER = (chanID, msgID, reaction, userID) => `/channels/${chanID}/messages/${msgID}/reactions/${reaction}/${userID}`;
module.exports.CHANNEL_MESSAGE_REACTIONS =                       (chanID, msgID) => `/channels/${chanID}/messages/${msgID}/reactions`;
module.exports.CHANNEL_MESSAGE =                                 (chanID, msgID) => `/channels/${chanID}/messages/${msgID}`;
module.exports.CHANNEL_MESSAGES =                                       (chanID) => `/channels/${chanID}/messages`;
module.exports.CHANNEL_PERMISSION =                             (chanID, overID) => `/channels/${chanID}/permissions/${overID}`;
module.exports.CHANNEL_PERMISSIONS =                                    (chanID) => `/channels/${chanID}/permissions`;
module.exports.CHANNEL_PIN =                                     (chanID, msgID) => `/channels/${chanID}/pins/${msgID}`;
module.exports.CHANNEL_PINS =                                           (chanID) => `/channels/${chanID}/pins`;
module.exports.CHANNEL_RECIPIENT =                             (groupID, userID) => `/channels/${groupID}/recipients/${userID}`;
module.exports.CHANNEL_TYPING =                                         (chanID) => `/channels/${chanID}/typing`;
module.exports.CHANNEL_VOICE_STATUS =                                   (chanID) => `/channels/${chanID}/voice-status`;
module.exports.CHANNEL_WEBHOOKS =                                       (chanID) => `/channels/${chanID}/webhooks`;
module.exports.CHANNELS =                                                           "/channels";
module.exports.CUSTOM_EMOJI_GUILD =                                    (emojiID) => `/emojis/${emojiID}/guild`;
module.exports.DISCOVERY_CATEGORIES =                                               "/discovery/categories";
module.exports.DISCOVERY_VALIDATION =                                               "/discovery/valid-term";
module.exports.GATEWAY =                                                            "/gateway";
module.exports.GATEWAY_BOT =                                                        "/gateway/bot";
module.exports.GUILD =                                                 (guildID) => `/guilds/${guildID}`;
module.exports.GUILD_AUDIT_LOGS =                                      (guildID) => `/guilds/${guildID}/audit-logs`;
module.exports.GUILD_BAN =                                   (guildID, memberID) => `/guilds/${guildID}/bans/${memberID}`;
module.exports.GUILD_BANS =                                            (guildID) => `/guilds/${guildID}/bans`;
module.exports.GUILD_BULK_BAN =                                        (guildID) => `/guilds/${guildID}/bulk-ban`;
module.exports.GUILD_CHANNELS =                                        (guildID) => `/guilds/${guildID}/channels`;
module.exports.GUILD_COMMAND =               (applicationID, guildID, commandID) => `/applications/${applicationID}/guilds/${guildID}/commands/${commandID}`;
module.exports.GUILD_COMMAND_PERMISSIONS =              (applicationID, guildID) => `/applications/${applicationID}/guilds/${guildID}/commands/permissions`;
module.exports.GUILD_COMMANDS =                         (applicationID, guildID) => `/applications/${applicationID}/guilds/${guildID}/commands`;
module.exports.GUILD_DISCOVERY =                                       (guildID) => `/guilds/${guildID}/discovery-metadata`;
module.exports.GUILD_DISCOVERY_CATEGORY =                  (guildID, categoryID) => `/guilds/${guildID}/discovery-categories/${categoryID}`;
module.exports.GUILD_EMOJI =                                  (guildID, emojiID) => `/guilds/${guildID}/emojis/${emojiID}`;
module.exports.GUILD_EMOJIS =                                          (guildID) => `/guilds/${guildID}/emojis`;
module.exports.GUILD_INTEGRATION =                             (guildID, inteID) => `/guilds/${guildID}/integrations/${inteID}`;
module.exports.GUILD_INTEGRATION_SYNC =                        (guildID, inteID) => `/guilds/${guildID}/integrations/${inteID}/sync`;
module.exports.GUILD_INTEGRATIONS =                                    (guildID) => `/guilds/${guildID}/integrations`;
module.exports.GUILD_INVITES =                                         (guildID) => `/guilds/${guildID}/invites`;
module.exports.GUILD_MEMBER =                                (guildID, memberID) => `/guilds/${guildID}/members/${memberID}`;
module.exports.GUILD_MEMBER_NICK =                           (guildID, memberID) => `/guilds/${guildID}/members/${memberID}/nick`;
module.exports.GUILD_MEMBER_ROLE =                   (guildID, memberID, roleID) => `/guilds/${guildID}/members/${memberID}/roles/${roleID}`;
module.exports.GUILD_MEMBERS =                                         (guildID) => `/guilds/${guildID}/members`;
module.exports.GUILD_MEMBERS_SEARCH =                                  (guildID) => `/guilds/${guildID}/members/search`;
module.exports.GUILD_MFA_LEVEL =                                       (guildID) => `/guilds/${guildID}/mfa`;
module.exports.GUILD_ONBOARDING =                                      (guildID) => `/guilds/${guildID}/onboarding`;
module.exports.GUILD_PREVIEW =                                         (guildID) => `/guilds/${guildID}/preview`;
module.exports.GUILD_PRUNE =                                           (guildID) => `/guilds/${guildID}/prune`;
module.exports.GUILD_ROLE =                                    (guildID, roleID) => `/guilds/${guildID}/roles/${roleID}`;
module.exports.GUILD_ROLES =                                           (guildID) => `/guilds/${guildID}/roles`;
module.exports.GUILD_SCHEDULED_EVENT =               (guildID, scheduledEventID) => `/guilds/${guildID}/scheduled-events/${scheduledEventID}`;
module.exports.GUILD_SCHEDULED_EVENT_USERS =         (guildID, scheduledEventID) => `/guilds/${guildID}/scheduled-events/${scheduledEventID}/users`;
module.exports.GUILD_SCHEDULED_EVENTS =                                (guildID) => `/guilds/${guildID}/scheduled-events`;
module.exports.GUILD_STICKER =                              (guildID, stickerID) => `/guilds/${guildID}/stickers/${stickerID}`;
module.exports.GUILD_STICKERS =                                        (guildID) => `/guilds/${guildID}/stickers`;
module.exports.GUILD_TEMPLATE =                                           (code) => `/guilds/templates/${code}`;
module.exports.GUILD_TEMPLATE_GUILD =                            (guildID, code) => `/guilds/${guildID}/templates/${code}`;
module.exports.GUILD_TEMPLATES =                                       (guildID) => `/guilds/${guildID}/templates`;
module.exports.GUILD_VANITY_URL =                                      (guildID) => `/guilds/${guildID}/vanity-url`;
module.exports.GUILD_VOICE_REGIONS =                                   (guildID) => `/guilds/${guildID}/regions`;
module.exports.GUILD_WEBHOOKS =                                        (guildID) => `/guilds/${guildID}/webhooks`;
module.exports.GUILD_WELCOME_SCREEN =                                  (guildID) => `/guilds/${guildID}/welcome-screen`;
module.exports.GUILD_WIDGET =                                          (guildID) => `/guilds/${guildID}/widget.json`;
module.exports.GUILD_WIDGET_IMAGE =                                    (guildID) => `/guilds/${guildID}/widget.png`;
module.exports.GUILD_WIDGET_SETTINGS =                                 (guildID) => `/guilds/${guildID}/widget`;
module.exports.GUILD_VOICE_STATE =                               (guildID, user) => `/guilds/${guildID}/voice-states/${user}`;
module.exports.GUILDS =                                                             "/guilds";
module.exports.INTERACTION_RESPOND =                 (interactID, interactToken) => `/interactions/${interactID}/${interactToken}/callback`;
module.exports.INVITE =                                               (inviteID) => `/invites/${inviteID}`;
module.exports.OAUTH2_APPLICATION =                                                 "/oauth2/applications/@me";
module.exports.ORIGINAL_INTERACTION_RESPONSE =            (appID, interactToken) => `/webhooks/${appID}/${interactToken}`;
module.exports.POLL_ANSWER_VOTERS =                 (channelID, msgID, answerID) => `/channels/${channelID}/polls/${msgID}/answers/${answerID}`;
module.exports.POLL_END =                                     (channelID, msgID) => `/channels/${channelID}/polls/${msgID}/expire`;
module.exports.ROLE_CONNECTION_METADATA_RECORDS =                        (appID) => `/applications/${appID}/role-connections/metadata`;
module.exports.STAGE_INSTANCE =                                      (channelID) => `/stage-instances/${channelID}`;
module.exports.STAGE_INSTANCES =                                                    "/stage-instances";
module.exports.STICKER =                                             (stickerID) => `/stickers/${stickerID}`;
module.exports.STICKER_PACKS =                                                      "/sticker-packs";
module.exports.THREAD_MEMBER =                               (channelID, userID) => `/channels/${channelID}/thread-members/${userID}`;
module.exports.THREAD_MEMBERS =                                      (channelID) => `/channels/${channelID}/thread-members`;
module.exports.THREAD_WITH_MESSAGE =                          (channelID, msgID) => `/channels/${channelID}/messages/${msgID}/threads`;
module.exports.THREAD_WITHOUT_MESSAGE =                              (channelID) => `/channels/${channelID}/threads`;
module.exports.THREADS_ARCHIVED =                              (channelID, type) => `/channels/${channelID}/threads/archived/${type}`;
module.exports.THREADS_ARCHIVED_JOINED =                             (channelID) => `/channels/${channelID}/users/@me/threads/archived/private`;
module.exports.THREADS_GUILD_ACTIVE =                                  (guildID) => `/guilds/${guildID}/threads/active`;
module.exports.USER =                                                   (userID) => `/users/${userID}`;
module.exports.USER_CHANNELS =                                          (userID) => `/users/${userID}/channels`;
module.exports.USER_GUILD =                                    (userID, guildID) => `/users/${userID}/guilds/${guildID}`;
module.exports.USER_GUILDS =                                            (userID) => `/users/${userID}/guilds`;
module.exports.VOICE_REGIONS =                                                      "/voice/regions";
module.exports.WEBHOOK =                                                (hookID) => `/webhooks/${hookID}`;
module.exports.WEBHOOK_MESSAGE =                          (hookID, token, msgID) => `/webhooks/${hookID}/${token}/messages/${msgID}`;
module.exports.WEBHOOK_SLACK =                                          (hookID) => `/webhooks/${hookID}/slack`;
module.exports.WEBHOOK_TOKEN =                                   (hookID, token) => `/webhooks/${hookID}/${token}`;
module.exports.WEBHOOK_TOKEN_SLACK =                             (hookID, token) => `/webhooks/${hookID}/${token}/slack`;

// CDN Endpoints
module.exports.ACHIEVEMENT_ICON =           (applicationID, achievementID, icon) => `/app-assets/${applicationID}/achievements/${achievementID}/icons/${icon}`;
module.exports.APPLICATION_ASSET =                        (applicationID, asset) => `/app-assets/${applicationID}/${asset}`;
module.exports.APPLICATION_ICON =                          (applicationID, icon) => `/app-icons/${applicationID}/${icon}`;
module.exports.BANNER =                                    (guildOrUserID, hash) => `/banners/${guildOrUserID}/${hash}`;
module.exports.CHANNEL_ICON =                                 (chanID, chanIcon) => `/channel-icons/${chanID}/${chanIcon}`;
module.exports.CUSTOM_EMOJI =                                          (emojiID) => `/emojis/${emojiID}`;
module.exports.DEFAULT_USER_AVATAR =                         (userDiscriminator) => `/embed/avatars/${userDiscriminator}`;
module.exports.GUILD_AVATAR =                     (guildID, userID, guildAvatar) => `/guilds/${guildID}/users/${userID}/avatars/${guildAvatar}`;
module.exports.GUILD_DISCOVERY_SPLASH =          (guildID, guildDiscoverySplash) => `/discovery-splashes/${guildID}/${guildDiscoverySplash}`;
module.exports.GUILD_ICON =                                 (guildID, guildIcon) => `/icons/${guildID}/${guildIcon}`;
module.exports.GUILD_SCHEDULED_EVENT_COVER =                (eventID, eventIcon) => `/guild-events/${eventID}/${eventIcon}`;
module.exports.GUILD_SPLASH =                             (guildID, guildSplash) => `/splashes/${guildID}/${guildSplash}`;
module.exports.ROLE_ICON =                                    (roleID, roleIcon) => `/role-icons/${roleID}/${roleIcon}`;
module.exports.TEAM_ICON =                                    (teamID, teamIcon) => `/team-icons/${teamID}/${teamIcon}`;
module.exports.USER_AVATAR =                                (userID, userAvatar) => `/avatars/${userID}/${userAvatar}`;
module.exports.USER_AVATAR_DECORATION =                         (userDecoration) => `/avatar-decoration-presets/${userDecoration}`;

// Client Endpoints
module.exports.MESSAGE_LINK =                    (guildID, channelID, messageID) => `/channels/${guildID}/${channelID}/${messageID}`;
