/* auto-generated by NAPI-RS */
/* eslint-disable */
/** The type of codec being used. */
export declare const enum Codec {
  UNKNOWN = 0,
  OPUS = 1,
  VP8 = 2,
  VP9 = 3,
  H264 = 4,
  H265 = 5,
  AV1 = 6
}

/** The maximum supported version of the DAVE protocol. */
export const DAVE_PROTOCOL_VERSION: number

export interface DecryptionStats {
  /** Number of decryption successes */
  successes: number
  /** Number of decryption failures */
  failures: number
  /** Total decryption duration in microseconds */
  duration: number
  /** Total amounts of decryption attempts */
  attempts: number
  /** Total amounts of packets that passed through */
  passthroughs: number
}

export interface EncryptionStats {
  /** Number of encryption successes */
  successes: number
  /** Number of encryption failures */
  failures: number
  /** Total encryption duration in microseconds */
  duration: number
  /** Total amounts of encryption attempts */
  attempts: number
  /** Maximum attempts reached at encryption */
  maxAttempts: number
}

/** The type of media being referenced. */
export declare const enum MediaType {
  AUDIO = 0,
  VIDEO = 1
}

/**
 * The operation type of the proposals payload.
 * @see https://daveprotocol.com/#dave_mls_proposals-27
 */
export declare const enum ProposalsOperationType {
  APPEND = 0,
  REVOKE = 1
}

/** The status of the DAVE session. */
export declare const enum SessionStatus {
  INACTIVE = 0,
  PENDING = 1,
  AWAITING_RESPONSE = 2,
  ACTIVE = 3
}
export declare class DAVESession {
  /**
   * @param protocolVersion The protocol version to use.
   * @param userId The user ID of the session.
   * @param channelId The channel ID of the session.
   * @param keyPair The key pair to use for this session. Will generate a new one if not specified.
   */
  constructor(protocolVersion: number, userId: string, channelId: string, keyPair?: SigningKeyPair | undefined | null)
  /**
   * Resets and re-initializes the session.
   * @param protocolVersion The protocol version to use.
   * @param userId The user ID of the session.
   * @param channelId The channel ID of the session.
   * @param keyPair The key pair to use for this session. Will generate a new one if not specified.
   */
  reinit(protocolVersion: number, userId: string, channelId: string, keyPair?: SigningKeyPair | undefined | null): void
  /**
   * Resets the session by deleting the group and clearing the storage.
   * If you want to re-initialize the session, use {@link reinit}.
   */
  reset(): void
  /** The DAVE protocol version used for this session. */
  get protocolVersion(): number
  /** The user ID for this session. */
  get userId(): string
  /** The channel ID (group ID in MLS standards) for this session. */
  get channelId(): string
  /** The epoch for this session, `undefined` if there is no group yet. */
  get epoch(): bigint | null
  /** Your own leaf index for this session, `undefined` if there is no group yet. */
  get ownLeafIndex(): number | null
  /** The ciphersuite being used in this session. */
  get ciphersuite(): number
  /** The current status of the session. */
  get status(): SessionStatus
  /** Whether the session is ready to encrypt/decrypt. */
  get ready(): boolean
  /** Get the epoch authenticator of this session's group. */
  getEpochAuthenticator(): Buffer | null
  /**
   * Get the voice privacy code of this session's group.
   * The result of this is created and cached each time a new transition is executed.
   * This is the equivalent of `generateDisplayableCode(epochAuthenticator, 30, 5)`.
   * @returns The current voice privacy code, or an empty string if the session is not active.
   * @see https://daveprotocol.com/#displayable-codes
   */
  get voicePrivacyCode(): string
  /**
   * Set the external sender this session will recieve from.
   * @param externalSenderData The serialized external sender data.
   * @throws Will throw if the external sender is invalid, or if the group has been established already.
   * @see https://daveprotocol.com/#dave_mls_external_sender_package-25
   */
  setExternalSender(externalSenderData: Buffer): void
  /**
   * Create, store, and return the serialized key package buffer.
   * Key packages are not meant to be reused, and will be recreated on each call of this function.
   */
  getSerializedKeyPackage(): Buffer
  /**
   * Process proposals from the voice server.
   * @param operationType The operation type of the proposals.
   * @param proposals The vector of proposals or proposal refs of the payload. (depending on operation type)
   * @param recognizedUserIds The recognized set of user IDs gathered from the voice gateway. Recommended to set so that incoming users are checked against.
   * @returns A commit (if there were queued proposals) and a welcome (if a member was added) that should be used to send an [opcode 28: dave_mls_commit_welcome](https://daveprotocol.com/#dave_mls_commit_welcome-28) ONLY if a commit was returned.
   * @see https://daveprotocol.com/#dave_mls_proposals-27
   */
  processProposals(operationType: ProposalsOperationType, proposals: Buffer, recognizedUserIds?: Array<string> | undefined | null): ProposalsResult
  /**
   * Process a welcome message.
   * @param welcome The welcome message to process.
   * @throws Will throw an error if the welcome is invalid. Send an [opcode 31: dave_mls_invalid_commit_welcome](https://daveprotocol.com/#dave_mls_invalid_commit_welcome-31) if this occurs.
   * @see https://daveprotocol.com/#dave_mls_welcome-30
   */
  processWelcome(welcome: Buffer): void
  /**
   * Process a commit.
   * @param commit The commit to process.
   * @throws Will throw an error if the commit is invalid. Send an [opcode 31: dave_mls_invalid_commit_welcome](https://daveprotocol.com/#dave_mls_invalid_commit_welcome-31) if this occurs.
   * @see https://daveprotocol.com/#dave_mls_announce_commit_transition-29
   */
  processCommit(commit: Buffer): void
  /**
   * Get the verification code of another member of the group.
   * This is the equivalent of `generateDisplayableCode(getPairwiseFingerprint(0, userId), 45, 5)`.
   * @see https://daveprotocol.com/#displayable-codes
   */
  getVerificationCode(userId: string): Promise<string>
  /**
   * Create a pairwise fingerprint of you and another member.
   * @see https://daveprotocol.com/#verification-fingerprint
   */
  getPairwiseFingerprint(version: number, userId: string): Promise<Buffer>
  /**
   * End-to-end encrypt a packet.
   * @param mediaType The type of media to encrypt
   * @param codec The codec of the packet
   * @param packet The packet to encrypt
   */
  encrypt(mediaType: MediaType, codec: Codec, packet: Buffer): Buffer
  /**
   * End-to-end encrypt an opus packet.
   * This is the shorthand for `encrypt(MediaType.AUDIO, Codec.OPUS, packet)`
   * @param packet The packet to encrypt
   */
  encryptOpus(packet: Buffer): Buffer
  /**
   * Get encryption stats.
   * @param [mediaType=MediaType.AUDIO] The media type, defaults to `MediaType.AUDIO`
   */
  getEncryptionStats(mediaType?: MediaType | undefined | null): EncryptionStats | null
  /**
   * Decrypt an end-to-end encrypted packet.
   * @param userId The user ID of the packet
   * @param mediaType The type of media to decrypt
   * @param packet The packet to decrypt
   */
  decrypt(userId: string, mediaType: MediaType, packet: Buffer): Buffer
  /**
   * Get decryption stats.
   * @param userId The user ID
   * @param [mediaType=MediaType.AUDIO] The media type, defaults to `MediaType.AUDIO`
   */
  getDecryptionStats(userId: string, mediaType?: MediaType | undefined | null): DecryptionStats | null
  /**
   * Get the IDs of the users in the current group.
   * @returns An array of user IDs, or an empty array if there is no group.
   */
  getUserIds(): Array<string>
  /**
   * Check whether this user's decryptor is in passthrough mode.
   * If passthrough mode is enabled, then unencrypted packets are allowed to be passed through the decryptor.
   * @param userId The user ID
   */
  canPassthrough(userId: string): boolean
  /**
   * Set whether passthrough mode is enabled on all decryptors.
   * @param passthroughMode Whether to enable passthrough mode
   * @param [transitionExpiry=10] The transition expiry (in seconds) to use when disabling passthrough mode, defaults to 10 seconds
   */
  setPassthroughMode(passthroughMode: boolean, transitionExpiry?: number | undefined | null): void
  /** @ignore */
  toString(): string
}
export type DaveSession = DAVESession

/** Whether davey is using a debug build. */
export const DEBUG_BUILD: boolean

/**
 * Generate a displayable code.
 * @see https://daveprotocol.com/#displayable-codes
 * @param data The data to generate a code with
 * @param desiredLength The desired length of the code
 * @param groupSize The group size of the code
 */
export declare function generateDisplayableCode(data: Buffer, desiredLength: number, groupSize: number): string

/**
 * Generate a key fingerprint.
 * @see https://daveprotocol.com/#verification-fingerprint
 * @param version The version of the fingerprint
 * @param key The key to fingerprint
 * @param userId The user ID of this fingerprint
 */
export declare function generateKeyFingerprint(version: number, key: Buffer, userId: string): Buffer

/** Create a P256 signing key pair. */
export declare function generateP256Keypair(): SigningKeyPair

/**
 * Generate a pairwise fingerprint.
 * @see https://daveprotocol.com/#verification-fingerprint
 * @param version The version of the fingerprint
 * @param localKey The local user's key
 * @param localKeyId The local user's ID
 * @param remoteKey The remote user's key
 * @param remoteKeyId The remote user's ID
 */
export declare function generatePairwiseFingerprint(version: number, localKey: Buffer, localUserId: string, remoteKey: Buffer, remoteUserId: string): Promise<Buffer>

export interface ProposalsResult {
  commit?: Buffer
  welcome?: Buffer
}

/** A signing key pair. */
export interface SigningKeyPair {
  /** The private key of this key pair. */
  private: Buffer
  /** The public key of this key pair. */
  public: Buffer
}

/** The version of the davey package being used. */
export const VERSION: string
