const { EmbedBuilder } = require('discord.js');

module.exports = {
  name: 'guildMemberAdd',
  async execute(member, client) {
    try {
      const ayarlar = client.loadAyarlar();
      const guildSettings = ayarlar[member.guild.id];
      if (!guildSettings) return;

      const kayitsizRol = member.guild.roles.cache.get(guildSettings.kayitsizRol);
      const kayitKanal = member.guild.channels.cache.get(guildSettings.kayitKanal);

      if (kayitsizRol) await member.roles.add(kayitsizRol).catch(() => {});
      if (!kayitKanal) return;

      if (!client.kayitWelcomeMsgs) client.kayitWelcomeMsgs = new Map();

      const iconUrl =
        'https://cdn.discordapp.com/icons/1441800571488178291/14980afc05fc5cd697c64a1dc7741ec5.webp?size=80';

      const embed = new EmbedBuilder()
        .setColor('#5865F2')
        .setTitle('✨ Hoş geldin!')
        .setDescription(
          `Selam ${member} 👋\n\n` +
          `Kayıt olmak için bu kanala **sadece nickini** yazman yeterli.\n` +
          `Örnek: \`rilaks\`, \`fu\`, \`lillian\`, \`arda\`, \`x7\`\n\n` +
          `⚠️ Uygunsuz veya hatalı nick denemelerinin tekrarı halinde, sistem otomatik olarak **3 denemede 5 dakikalık timeout** uygular.`
        )
        .setThumbnail(iconUrl)
        .setFooter({ text: 'developed by rilaks' })
        .setTimestamp();

      // ✅ 1) Ping düşsün diye ayrı mesaj (sonra silinecek)
      const pingMsg = await kayitKanal.send({ content: `${member}` }).catch(() => null);
      if (pingMsg) setTimeout(() => pingMsg.delete().catch(() => {}), 1500);

      // ✅ 2) Sadece embed mesajı (kayıt olunca da siliniyor, olmazsa 10 dk sonra silinecek)
      const sent = await kayitKanal.send({ embeds: [embed] }).catch(() => null);

      if (sent) {
        const key = `${member.guild.id}:${member.id}`;
        client.kayitWelcomeMsgs.set(key, sent.id);

        // 10 dakika sonra hâlâ duruyorsa sil
        setTimeout(async () => {
          try {
            // kullanıcı bu sürede kayıt olduysa messageCreate zaten key'i silmiş olacak
            if (!client.kayitWelcomeMsgs) return;
            const still = client.kayitWelcomeMsgs.get(key);
            if (!still) return;

            const msg = await kayitKanal.messages.fetch(still).catch(() => null);
            if (msg) await msg.delete().catch(() => {});

            client.kayitWelcomeMsgs.delete(key);
          } catch {}
        }, 10 * 60 * 1000);
      }
    } catch (error) {
      console.error('guildMemberAdd hatası:', error);
    }
  },
};
