const {
  SlashCommandBuilder,
  PermissionFlagsBits,
  EmbedBuilder,
  ActionRowBuilder,
  ButtonBuilder,
  ButtonStyle
} = require('discord.js');

module.exports = {
  data: new SlashCommandBuilder()
    .setName('kayıt-sıfırla')
    .setDescription('Nick-only kayıt sistemini tamamen sıfırlar')
    .setDefaultMemberPermissions(PermissionFlagsBits.Administrator),

  async execute(interaction) {
    const embed = new EmbedBuilder()
      .setColor('#ff9900')
      .setTitle('⚠️ Onay Gerekli')
      .setDescription(
        '**Nick-only kayıt sistemi tamamen silinecek.**\n\n' +
        '• Kayıt / sohbet / ses teyit kanalları\n' +
        '• Kayıtsız & Üye rolleri\n' +
        '• Kayıt ayarları\n\n' +
        '⚠️ **Bu işlem geri alınamaz!**'
      )
      .setFooter({ text: 'Devam etmek için bir seçenek seçin' })
      .setTimestamp();

    const row = new ActionRowBuilder().addComponents(
      new ButtonBuilder()
        .setCustomId('sifirla_evet')
        .setLabel('Evet, Sıfırla')
        .setStyle(ButtonStyle.Danger),
      new ButtonBuilder()
        .setCustomId('sifirla_iptal')
        .setLabel('Hayır, İptal Et')
        .setStyle(ButtonStyle.Secondary)
    );

    await interaction.reply({
      embeds: [embed],
      components: [row],
      ephemeral: true
    });
  },

  async handleInteraction(interaction, client) {
    if (!interaction.isButton()) return;

    const ayarlar = client.loadAyarlar();
    const guildSettings = ayarlar[interaction.guild.id];

    // ❌ İptal
    if (interaction.customId === 'sifirla_iptal') {
      const embed = new EmbedBuilder()
        .setColor('#5865F2')
        .setTitle('❌ İşlem İptal Edildi')
        .setDescription('Kayıt sistemi korunuyor.')
        .setTimestamp();

      return interaction.update({ embeds: [embed], components: [] });
    }

    // ✅ Onaylandı
    if (interaction.customId === 'sifirla_evet') {
      if (guildSettings) {
        // 🧹 Kanalları sil
        const kanalIdler = [
          guildSettings.kayitKanal,
          guildSettings.sohbetKanal,
          guildSettings.sesTeyitKanal
        ].filter(Boolean);

        for (const id of kanalIdler) {
          const kanal = await interaction.guild.channels.fetch(id).catch(() => null);
          if (kanal) await kanal.delete().catch(() => {});
        }

        // 🧹 Rolleri sil
        const rolIdler = [
          guildSettings.kayitsizRol,
          guildSettings.uyeRol
        ].filter(Boolean);

        for (const id of rolIdler) {
          const rol = await interaction.guild.roles.fetch(id).catch(() => null);
          if (rol) await rol.delete().catch(() => {});
        }

        // 🧹 Ayarları sil
        delete ayarlar[interaction.guild.id];
        client.saveAyarlar(ayarlar);
      }

      const embed = new EmbedBuilder()
        .setColor('#57f287')
        .setTitle('✅ Kayıt Sistemi Sıfırlandı')
        .setDescription(
          'Nick-only kayıt sistemi tamamen kaldırıldı.\n\n' +
          'Tekrar kurmak için `/kayıt-kur` komutunu kullanabilirsiniz.'
        )
        .setTimestamp();

      return interaction.update({ embeds: [embed], components: [] });
    }
  }
};
