const { SlashCommandBuilder, PermissionFlagsBits, EmbedBuilder } = require('discord.js');

// 🔒 Nick kontrolü (messageCreate ile AYNI kurallar)
function nicknameGecerliMi(nick) {
  if (!nick) return { ok: false, reason: 'Nick boş olamaz.' };

  const text = nick.trim();

  if (/\s/.test(text)) return { ok: false, reason: 'Nick boşluk içeremez.' };
  if (text.length < 1) return { ok: false, reason: 'En az 1 karakter olmalı.' };
  if (text.length > 24) return { ok: false, reason: 'En fazla 24 karakter olmalı.' };

  const allowedRegex = /^[a-zA-Z0-9]+$/;
  if (!allowedRegex.test(text)) {
    return { ok: false, reason: 'Sadece harf ve sayı kullanabilirsin.' };
  }

  const lower = text.toLowerCase();

  if (/(.)\1{3,}/i.test(lower)) {
    return { ok: false, reason: 'Aşırı tekrar içeremez.' };
  }

  const badWords = [
    'admin','mod','moderator','yetkili','owner','kurucu','founder','support','destek','staff',
    'amk','aq','mk','oc','oç','orospu','pic','piç','sik','siktir','yarrak','yarak',
    'anan','baban','ibne','gavat','pezevenk','amina','amına','yavsak',
    'fuck','shit','bitch','slut','whore','dick','pussy','nigger','nigga',
    'sex','porn','porno','nsfw','xxx'
  ];

  if (badWords.some(w => lower.includes(w))) {
    return { ok: false, reason: 'Uygunsuz kelime içeriyor.' };
  }

  return { ok: true, nick: text };
}

module.exports = {
  data: new SlashCommandBuilder()
    .setName('kayıt')
    .setDescription('Yetkili tarafından manuel kayıt (sadece nick)')
    .setDefaultMemberPermissions(PermissionFlagsBits.KickMembers)
    .addUserOption(option =>
      option
        .setName('kullanıcı')
        .setDescription('Kayıt edilecek kullanıcı')
        .setRequired(true)
    )
    .addStringOption(option =>
      option
        .setName('nick')
        .setDescription('Verilecek nick (harf + sayı)')
        .setRequired(true)
    ),

  async execute(interaction, client) {
    const guildSettings = client.loadAyarlar()[interaction.guild.id];
    if (!guildSettings) {
      return interaction.reply({ content: '⚠️ Sunucuda kayıt sistemi kurulu değil.', ephemeral: true });
    }

    const uye = interaction.options.getMember('kullanıcı');
    if (!uye) {
      return interaction.reply({ content: '⚠️ Kullanıcı sunucuda bulunamadı.', ephemeral: true });
    }

    const nickInput = interaction.options.getString('nick');
    const kontrol = nicknameGecerliMi(nickInput);

    if (!kontrol.ok) {
      return interaction.reply({
        content: `❌ Geçersiz nick.\nSebep: **${kontrol.reason}**\n\nÖrnekler: \`rilaks\`, \`fu\`, \`lillian\`, \`a\`, \`x7\``,
        ephemeral: true
      });
    }

    const yeniNick = kontrol.nick;

    const kayitsizRol = interaction.guild.roles.cache.get(guildSettings.kayitsizRol);
    const uyeRol = interaction.guild.roles.cache.get(guildSettings.uyeRol);

    // ✅ Kayıt işlemi
    await uye.setNickname(yeniNick).catch(() => {});
    if (kayitsizRol) await uye.roles.remove(kayitsizRol).catch(() => {});
    if (uyeRol) await uye.roles.add(uyeRol).catch(() => {});

    // Sohbet kanalına bildirim
    const sohbetKanal = interaction.guild.channels.cache.get(guildSettings.sohbetKanal);
    if (sohbetKanal) {
      const embed = new EmbedBuilder()
        .setColor('#57f287')
        .setTitle('✅ Manuel Kayıt')
        .setDescription(
          `${uye} yetkili tarafından kayıt edildi.\n\n` +
          `> 🏷️ **Nick:** ${yeniNick}\n` +
          `> 👮 **Yetkili:** ${interaction.user}`
        )
        .setTimestamp();

      sohbetKanal.send({ embeds: [embed] }).catch(() => {});
    }

    return interaction.reply({
      content: `✅ **${uye.user.tag}** başarıyla kayıt edildi.\nNick: **${yeniNick}**`,
      ephemeral: true
    });
  }
};
