/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_villages.pooladditions;

import com.craisinlord.integrated_api.IntegratedAPI;
import com.craisinlord.integrated_api.events.lifecycle.ServerGoingToStartEvent;
import com.craisinlord.integrated_api.mixins.structures.ListPoolElementAccessor;
import com.craisinlord.integrated_api.mixins.structures.SinglePoolElementAccessor;
import com.craisinlord.integrated_api.mixins.structures.StructurePoolAccessor;
import com.craisinlord.integrated_api.mixins.structures.StructureTemplateManagerAccessor;
import com.craisinlord.integrated_api.utils.GeneralUtils;
import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;

public final class PoolAdditionMerger {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().create();
    private static final String DATA_TYPE = "integrated_villages_pool_additions";
    private static final int FILE_SUFFIX_LENGTH = ".json".length();

    private PoolAdditionMerger() {
    }

    public static void mergeAdditionPools(ServerGoingToStartEvent event) {
        ResourceManager resourceManager = ((StructureTemplateManagerAccessor)event.getServer().m_236738_()).integratedapi_getResourceManager();
        Map poolAdditionJSON = GeneralUtils.getAllDatapacksJSONElement((ResourceManager)resourceManager, (Gson)GSON, (String)DATA_TYPE, (int)FILE_SUFFIX_LENGTH);
        PoolAdditionMerger.parsePoolsAndBeginMerger(poolAdditionJSON, (RegistryAccess)event.getServer().m_206579_(), event.getServer().m_236738_());
    }

    private static void parsePoolsAndBeginMerger(Map<ResourceLocation, List<JsonElement>> poolAdditionJSON, RegistryAccess dynamicRegistryManager, StructureTemplateManager StructureTemplateManager2) {
        Registry poolRegistry = dynamicRegistryManager.m_175515_(Registries.f_256948_);
        RegistryOps customRegistryOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)dynamicRegistryManager);
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : poolAdditionJSON.entrySet()) {
            if (poolRegistry.m_7745_(entry.getKey()) == null) continue;
            for (JsonElement jsonElement : entry.getValue()) {
                try {
                    AdditionalStructureTemplatePool.DIRECT_CODEC.parse((DynamicOps)customRegistryOps, (Object)jsonElement).resultOrPartial(messageString -> PoolAdditionMerger.logBadData((ResourceLocation)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMerger.mergeIntoExistingPool(validPool, (StructureTemplatePool)poolRegistry.m_7745_((ResourceLocation)entry.getKey()), StructureTemplateManager2));
                }
                catch (Exception e) {
                    IntegratedAPI.LOGGER.error("\nIntegrated API: Pool Addition json failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nEntry failed to be resolved: %s\nRegistry being used: %s\nError message is: %s".formatted(entry.getKey(), poolRegistry, e.getMessage()).indent(1));
                }
            }
        }
    }

    private static void mergeIntoExistingPool(AdditionalStructureTemplatePool feedingPool, StructureTemplatePool gluttonyPool, StructureTemplateManager structureTemplateManager) {
        ObjectArrayList elements = new ObjectArrayList((ObjectList)((StructurePoolAccessor)gluttonyPool).integratedapi_getTemplates());
        ArrayList elementCounts = new ArrayList(((StructurePoolAccessor)gluttonyPool).integratedapi_getRawTemplates());
        elements.addAll((ObjectList)((StructurePoolAccessor)feedingPool).integratedapi_getTemplates());
        elementCounts.addAll(((StructurePoolAccessor)feedingPool).integratedapi_getRawTemplates());
        for (StructurePoolElement element : elements) {
            if (element instanceof SinglePoolElement) {
                SinglePoolElement singlePoolElement = (SinglePoolElement)element;
                Optional pieceRL = ((SinglePoolElementAccessor)singlePoolElement).integratedapi_getTemplate().left();
                if (pieceRL.isEmpty()) continue;
                PoolAdditionMerger.checkIfPieceExists(feedingPool, structureTemplateManager, (ResourceLocation)pieceRL.get());
                continue;
            }
            if (!(element instanceof ListPoolElement)) continue;
            ListPoolElement listPoolElement = (ListPoolElement)element;
            for (StructurePoolElement listElement : ((ListPoolElementAccessor)listPoolElement).integratedapi_getElements()) {
                SinglePoolElement singlePoolElement;
                Optional pieceRL;
                if (!(listElement instanceof SinglePoolElement) || (pieceRL = ((SinglePoolElementAccessor)(singlePoolElement = (SinglePoolElement)listElement)).integratedapi_getTemplate().left()).isEmpty()) continue;
                PoolAdditionMerger.checkIfPieceExists(feedingPool, structureTemplateManager, (ResourceLocation)pieceRL.get());
            }
        }
        ((StructurePoolAccessor)gluttonyPool).integratedapi_setTemplates(elements);
        ((StructurePoolAccessor)gluttonyPool).integratedapi_setRawTemplates(elementCounts);
    }

    private static void checkIfPieceExists(AdditionalStructureTemplatePool feedingPool, StructureTemplateManager structureTemplateManager, ResourceLocation pieceRL) {
        ResourceLocation resourcelocation = new ResourceLocation(pieceRL.m_135827_(), "structures/" + pieceRL.m_135815_() + ".nbt");
        try {
            InputStream inputstream = ((StructureTemplateManagerAccessor)structureTemplateManager).integratedapi_getResourceManager().m_215595_(resourcelocation);
            if (inputstream.available() == 0 || inputstream.read(new byte[1]) == -1) {
                IntegratedAPI.LOGGER.error("(Integrated Villages POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.name, (Object)pieceRL);
            }
            inputstream.close();
        }
        catch (Throwable filenotfoundexception) {
            IntegratedAPI.LOGGER.error("(Integrated Villages POOL MERGER) Found an entry in {} that points to the non-existent nbt file called {}", (Object)feedingPool.name, (Object)pieceRL);
        }
    }

    private static void logBadData(ResourceLocation poolPath, String messageString) {
        IntegratedAPI.LOGGER.error("(Integrated API POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }

    private static class AdditionalStructureTemplatePool
    extends StructureTemplatePool {
        private static final Codec<ExpandedPoolEntry> EXPANDED_POOL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructurePoolElement.f_210468_.fieldOf("element").forGetter(ExpandedPoolEntry::poolElement), (App)Codec.intRange((int)1, (int)5000).fieldOf("weight").forGetter(ExpandedPoolEntry::weight), (App)Codec.STRING.optionalFieldOf("required_mod").forGetter(ExpandedPoolEntry::requiredMod)).apply((Applicative)instance, ExpandedPoolEntry::new));
        public static final Codec<AdditionalStructureTemplatePool> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(structureTemplatePool -> structureTemplatePool.name), (App)ExtraCodecs.m_184415_(() -> ((MutableObject)StructurePoolAccessor.getCODEC_REFERENCE()).getValue()).fieldOf("fallback").forGetter(StructureTemplatePool::m_254935_), (App)EXPANDED_POOL_ENTRY_CODEC.listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.rawTemplatesWithConditions)).apply((Applicative)instance, AdditionalStructureTemplatePool::new));
        protected final List<ExpandedPoolEntry> rawTemplatesWithConditions;
        protected final ResourceLocation name;

        public AdditionalStructureTemplatePool(ResourceLocation name, Holder<StructureTemplatePool> fallback, List<ExpandedPoolEntry> rawTemplatesWithConditions) {
            super(fallback, rawTemplatesWithConditions.stream().filter(triple -> PlatformHooks.isModLoaded((String)triple.requiredMod.get())).map(triple -> Pair.of((Object)triple.poolElement(), (Object)triple.weight())).collect(Collectors.toList()));
            this.rawTemplatesWithConditions = rawTemplatesWithConditions;
            this.name = name;
        }

        public record ExpandedPoolEntry(StructurePoolElement poolElement, Integer weight, Optional<String> requiredMod) {
        }
    }
}

