/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.listeners;

import com.majruszlibrary.entity.EntityHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyWaveFinished;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RewardsController {
    private static void update(OnUndeadArmyWaveFinished data) {
        RewardsController.giveExperienceReward(data.undeadArmy);
        if (data.undeadArmy.isLastWave() && UndeadArmyConfig.RESET_ALL_PARTICIPANTS_KILLS) {
            RewardsController.resetAllKillRequirements(data.undeadArmy);
        }
    }

    private static void giveExperienceReward(UndeadArmy undeadArmy) {
        UndeadArmyConfig.WaveDef waveDef = UndeadArmyConfig.WAVE_DEFS.get(undeadArmy.currentWave);
        undeadArmy.participants.forEach(participant -> {
            for (int i = 0; i < waveDef.experience / 4; ++i) {
                EntityHelper.spawnExperience((Level)undeadArmy.getLevel(), (Vec3)participant.m_20182_(), (int)4);
            }
        });
    }

    private static void resetAllKillRequirements(UndeadArmy undeadArmy) {
        undeadArmy.participants.forEach(participant -> {});
    }

    static {
        OnUndeadArmyWaveFinished.listen(RewardsController::update);
    }
}

