/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.listeners;

import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyLoaded;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStateChanged;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyTicked;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ProgressIndicator {
    private static void update(OnUndeadArmyTicked data) {
        ProgressIndicator.updateVisibility(data.undeadArmy);
        ProgressIndicator.updateParticipants(data.undeadArmy);
        ProgressIndicator.updateProgress(data.undeadArmy);
    }

    private static void update(OnUndeadArmyStateChanged data) {
        data.undeadArmy.waveInfo.m_6456_(ProgressIndicator.getPhaseComponent(data.undeadArmy));
        if (data.undeadArmy.phase.state == UndeadArmy.Phase.State.FINISHED) {
            ProgressIndicator.removeParticipants(data.undeadArmy);
        }
    }

    private static void update(OnUndeadArmyLoaded data) {
        data.undeadArmy.waveInfo.m_6456_(ProgressIndicator.getPhaseComponent(data.undeadArmy));
    }

    private static void updateVisibility(UndeadArmy undeadArmy) {
        boolean isBossAlive = undeadArmy.boss != null;
        undeadArmy.waveInfo.m_8321_(undeadArmy.phase.state != UndeadArmy.Phase.State.STARTED);
        if (!undeadArmy.bossInfo.m_8323_() && isBossAlive) {
            undeadArmy.bossInfo.m_6456_(ProgressIndicator.getBossName(undeadArmy));
        }
        undeadArmy.bossInfo.m_8321_(isBossAlive);
    }

    private static void updateParticipants(UndeadArmy undeadArmy) {
        if (undeadArmy.phase.state == UndeadArmy.Phase.State.FINISHED) {
            return;
        }
        ArrayList currentParticipants = new ArrayList(undeadArmy.waveInfo.m_8324_());
        undeadArmy.participants.forEach(player -> {
            if (!currentParticipants.contains(player)) {
                undeadArmy.waveInfo.m_6543_(player);
                undeadArmy.bossInfo.m_6543_(player);
            }
        });
        currentParticipants.forEach(player -> {
            if (!undeadArmy.participants.contains(player)) {
                undeadArmy.waveInfo.m_6539_(player);
                undeadArmy.bossInfo.m_6539_(player);
            }
        });
    }

    private static void updateProgress(UndeadArmy undeadArmy) {
        switch (undeadArmy.phase.state) {
            case STARTED: {
                undeadArmy.waveInfo.m_142711_(0.0f);
                break;
            }
            case WAVE_PREPARING: {
                undeadArmy.waveInfo.m_142711_(undeadArmy.phase.getRatio());
                undeadArmy.bossInfo.m_142711_(0.0f);
                break;
            }
            case WAVE_ONGOING: {
                undeadArmy.waveInfo.m_142711_(ProgressIndicator.getHealthRatioLeft(undeadArmy));
                undeadArmy.bossInfo.m_142711_(ProgressIndicator.getBossHealthRatioLeft(undeadArmy));
                break;
            }
            case UNDEAD_DEFEATED: {
                undeadArmy.waveInfo.m_142711_(0.0f);
                break;
            }
            case UNDEAD_WON: {
                undeadArmy.waveInfo.m_142711_(1.0f);
            }
        }
    }

    private static void removeParticipants(UndeadArmy undeadArmy) {
        undeadArmy.waveInfo.m_7706_();
        undeadArmy.bossInfo.m_7706_();
    }

    private static Component getPhaseComponent(UndeadArmy undeadArmy) {
        return switch (undeadArmy.phase.state) {
            case UndeadArmy.Phase.State.WAVE_PREPARING -> TextHelper.translatable((String)"majruszsdifficulty.undead_army.%s".formatted(undeadArmy.currentWave > 0 ? "between_waves" : "title"), (Object[])new Object[0]);
            case UndeadArmy.Phase.State.WAVE_ONGOING -> TextHelper.translatable((String)"majruszsdifficulty.undead_army.title", (Object[])new Object[0]).m_130946_(" ").m_7220_((Component)TextHelper.translatable((String)"majruszsdifficulty.undead_army.wave", (Object[])new Object[]{TextHelper.toRoman((int)undeadArmy.currentWave)}));
            case UndeadArmy.Phase.State.UNDEAD_DEFEATED -> TextHelper.translatable((String)"majruszsdifficulty.undead_army.victory", (Object[])new Object[0]);
            case UndeadArmy.Phase.State.UNDEAD_WON -> TextHelper.translatable((String)"majruszsdifficulty.undead_army.failed", (Object[])new Object[0]);
            default -> TextHelper.empty();
        };
    }

    private static float getHealthRatioLeft(UndeadArmy undeadArmy) {
        if (ProgressIndicator.hasNooneSpawnedYet(undeadArmy)) {
            return 1.0f;
        }
        float healthLeft = 0.0f;
        float healthTotal = Math.max((float)undeadArmy.phase.healthTotal, 1.0f);
        for (UndeadArmy.MobInfo mobInfo : undeadArmy.mobsLeft) {
            healthLeft += mobInfo.getHealth(undeadArmy.getLevel());
        }
        return Mth.m_14036_((float)(healthLeft / healthTotal), (float)0.0f, (float)1.0f);
    }

    private static boolean hasNooneSpawnedYet(UndeadArmy undeadArmy) {
        return undeadArmy.mobsLeft.stream().allMatch(mob -> mob.toEntity(undeadArmy.getLevel()) == null);
    }

    private static float getBossHealthRatioLeft(UndeadArmy undeadArmy) {
        float f;
        Entity entity = undeadArmy.boss;
        if (entity instanceof LivingEntity) {
            LivingEntity boss = (LivingEntity)entity;
            f = Mth.m_14036_((float)(boss.m_21223_() / boss.m_21233_()), (float)0.0f, (float)1.0f);
        } else {
            f = 0.0f;
        }
        return f;
    }

    private static Component getBossName(UndeadArmy undeadArmy) {
        return undeadArmy.boss.m_5446_().m_6881_().m_130940_(ChatFormatting.RED);
    }

    static {
        OnUndeadArmyTicked.listen(ProgressIndicator::update);
        OnUndeadArmyStateChanged.listen(ProgressIndicator::update);
        OnUndeadArmyLoaded.listen(ProgressIndicator::update);
    }
}

