/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.listeners;

import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.UndeadArmyHelper;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyLoaded;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStateChanged;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyTicked;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class MobSpawner {
    private static void tryToSpawn(OnUndeadArmyTicked data) {
        data.undeadArmy.mobsLeft.stream().filter(mobDef -> mobDef.uuid == null).findFirst().ifPresent(mobInfo -> MobSpawner.spawnMob(data.undeadArmy, mobInfo));
    }

    private static void generateMobList(OnUndeadArmyStateChanged data) {
        float sizeMultiplier = 1.0f + (float)(data.undeadArmy.participants.size() - 1) * UndeadArmyConfig.EXTRA_PLAYER_RATIO;
        UndeadArmyConfig.WaveDef waveDef = UndeadArmyConfig.WAVE_DEFS.get(data.undeadArmy.currentWave);
        waveDef.mobDefs.forEach(mobDef -> {
            int count = Random.round((double)((float)mobDef.count * sizeMultiplier));
            for (int idx = 0; idx < count; ++idx) {
                data.undeadArmy.mobsLeft.add(new UndeadArmy.MobInfo((UndeadArmyConfig.MobDef)mobDef, MobSpawner.getRandomSpawnPosition(data.undeadArmy), false));
            }
        });
        if (waveDef.bossDef != null) {
            data.undeadArmy.mobsLeft.add(new UndeadArmy.MobInfo(waveDef.bossDef, MobSpawner.getRandomSpawnPosition(data.undeadArmy), true));
        }
        data.undeadArmy.phase.healthTotal = 0;
    }

    private static void readdGoals(OnUndeadArmyLoaded data) {
        data.undeadArmy.mobsLeft.forEach(mobInfo -> {
            Entity patt2876$temp = mobInfo.toEntity(data.getServerLevel());
            if (patt2876$temp instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)patt2876$temp;
                MobSpawner.addGoals(mob, data.undeadArmy.position);
            }
        });
    }

    private static void spawnMob(UndeadArmy undeadArmy, UndeadArmy.MobInfo mobInfo) {
        Vec3 position = AnyPos.from((BlockPos)mobInfo.position).add((Number)0.0, (Number)0.25, (Number)0.0).vec3();
        Entity entity = EntityHelper.createSpawner(() -> mobInfo.type, (Level)undeadArmy.getLevel()).position(position).spawn();
        if (!(entity instanceof PathfinderMob)) {
            undeadArmy.mobsLeft.remove(mobInfo);
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        mobInfo.uuid = mob.m_20148_();
        MobSpawner.updateWaveHealth(undeadArmy, mobInfo);
        MobSpawner.tryToLoadEquipment(mob, mobInfo);
        MobSpawner.addGoals(mob, undeadArmy.position);
        MobSpawner.makePersistent(mob);
    }

    private static void updateWaveHealth(UndeadArmy undeadArmy, UndeadArmy.MobInfo mobInfo) {
        undeadArmy.phase.healthTotal = (int)((float)undeadArmy.phase.healthTotal + mobInfo.getMaxHealth(undeadArmy.getLevel()));
    }

    private static Vec3 buildOffset(UndeadArmy undeadArmy) {
        int spawnRadius = UndeadArmyConfig.AREA_RADIUS - 15;
        UndeadArmy.Direction direction = undeadArmy.direction;
        int x = direction.z != 0 ? 24 : 8;
        int y = 0;
        int z = direction.x != 0 ? 24 : 8;
        return AnyPos.from((Number)(direction.x * spawnRadius), (Number)0, (Number)(direction.z * spawnRadius)).add(Random.nextVector((int)(-x), (int)x, (int)(-y), (int)y, (int)(-z), (int)z)).vec3();
    }

    private static void tryToLoadEquipment(PathfinderMob mob, UndeadArmy.MobInfo mobInfo) {
        if (mobInfo.equipment == null) {
            return;
        }
        LootHelper.getLootTable((ResourceLocation)mobInfo.equipment).m_287195_(LootHelper.toGiftParams((Entity)mob)).forEach(itemStack -> ItemHelper.equip((Mob)mob, (ItemStack)itemStack));
        Arrays.stream(EquipmentSlot.values()).forEach(slot -> mob.m_21409_(slot, 0.025f));
    }

    private static void addGoals(PathfinderMob mob, BlockPos position) {
        EntityHelper.getTargetSelector((Mob)mob).m_25352_(0, (Goal)new UndeadArmyForgiveTeammateGoal(mob));
        EntityHelper.getGoalSelector((Mob)mob).m_25352_(4, (Goal)new UndeadArmyAttackPositionGoal((Mob)mob, position));
    }

    private static void makePersistent(PathfinderMob mob) {
        mob.m_21530_();
    }

    private static BlockPos getRandomSpawnPosition(UndeadArmy undeadArmy) {
        int z;
        int x;
        int y;
        int tries = 0;
        do {
            Vec3 offset = MobSpawner.buildOffset(undeadArmy);
            x = undeadArmy.position.m_123341_() + (int)offset.f_82479_;
            z = undeadArmy.position.m_123343_() + (int)offset.f_82481_;
        } while ((y = undeadArmy.getLevel().m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z)) != undeadArmy.getLevel().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) && ++tries < 5);
        return new BlockPos(x, y, z);
    }

    static {
        OnUndeadArmyTicked.listen(MobSpawner::tryToSpawn).addCondition(data -> TimeHelper.haveSecondsPassed((double)1.0)).addCondition(data -> data.undeadArmy.phase.state == UndeadArmy.Phase.State.WAVE_ONGOING);
        OnUndeadArmyStateChanged.listen(MobSpawner::generateMobList).addCondition(data -> data.undeadArmy.phase.state == UndeadArmy.Phase.State.WAVE_PREPARING);
        OnUndeadArmyLoaded.listen(MobSpawner::readdGoals);
    }

    private static class UndeadArmyForgiveTeammateGoal
    extends Goal {
        final PathfinderMob mob;

        public UndeadArmyForgiveTeammateGoal(PathfinderMob mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public void m_8056_() {
            this.mob.m_6710_(null);
            this.mob.m_6703_(null);
            this.mob.m_21561_(false);
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && UndeadArmyHelper.isPartOfUndeadArmy((Entity)this.mob) && UndeadArmyHelper.isPartOfUndeadArmy((Entity)this.mob.m_5448_());
        }
    }

    private static class UndeadArmyAttackPositionGoal
    extends Goal {
        final Mob undead;
        final BlockPos attackPosition;
        final PathNavigation navigation;
        final float speedModifier = 1.25f;
        final float maxDistanceFromPosition = 16.0f;
        int ticksToRecalculatePath = 0;

        public UndeadArmyAttackPositionGoal(Mob mob, BlockPos attackPosition) {
            this.undead = mob;
            this.navigation = mob.m_21573_();
            this.attackPosition = attackPosition;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.isInRadius() && !this.hasAnyTarget();
        }

        public boolean m_8045_() {
            return !this.m_8036_() && !this.navigation.m_26571_();
        }

        public void m_8056_() {
            this.ticksToRecalculatePath = 0;
        }

        public void m_8037_() {
            if (--this.ticksToRecalculatePath > 0) {
                return;
            }
            this.ticksToRecalculatePath = 10;
            double d = this.attackPosition.m_123341_();
            double d2 = this.attackPosition.m_123342_();
            double d3 = this.attackPosition.m_123343_();
            Objects.requireNonNull(this);
            this.navigation.m_26519_(d, d2, d3, 1.25);
        }

        private boolean isInRadius() {
            double d = this.getDistanceToAttackPosition();
            Objects.requireNonNull(this);
            return d < 16.0;
        }

        private boolean hasAnyTarget() {
            return this.undead.m_5448_() != null || this.undead.m_21188_() != null;
        }

        private double getDistanceToAttackPosition() {
            return AnyPos.from((Vec3)this.undead.m_20182_()).dist2d(this.attackPosition.m_252807_()).doubleValue();
        }
    }
}

