/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.collection.DefaultMap;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnMobSpawnLimitGet;
import com.majruszlibrary.events.OnMobSpawnRateGet;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import com.majruszsdifficulty.gamestage.GameStageValue;
import java.util.Objects;
import net.minecraft.world.entity.MobCategory;

public class SpawnRateIncreaser {
    private static boolean IS_ENABLED = true;
    private static GameStageValue<Float> MULTIPLIER = GameStageValue.of(DefaultMap.defaultEntry((Object)Float.valueOf(1.0f)), DefaultMap.entry((String)"expert", (Object)Float.valueOf(1.1f)), DefaultMap.entry((String)"master", (Object)Float.valueOf(1.2f)));

    private static void increase(OnMobSpawnRateGet data) {
        float f = data.value;
        Objects.requireNonNull(data);
        data.value = f + 1.0f * (MULTIPLIER.get(GameStageHelper.getGlobalGameStage()).floatValue() - 1.0f);
    }

    private static void increase(OnMobSpawnLimitGet data) {
        data.value = (int)((float)data.value + (float)data.original * (MULTIPLIER.get(GameStageHelper.getGlobalGameStage()).floatValue() - 1.0f));
    }

    static {
        OnMobSpawnRateGet.listen(SpawnRateIncreaser::increase).addCondition(data -> IS_ENABLED).addCondition(data -> data.category.equals((Object)MobCategory.MONSTER));
        OnMobSpawnLimitGet.listen(SpawnRateIncreaser::increase).addCondition(data -> IS_ENABLED).addCondition(data -> data.category.equals((Object)MobCategory.MONSTER));
        Serializables.getStatic(Config.Features.class).define("spawn_rate_increaser", SpawnRateIncreaser.class);
        Serializables.getStatic(SpawnRateIncreaser.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("multiplier", Reader.map((IReader)Reader.number()), () -> MULTIPLIER.get(), v -> {
            MULTIPLIER = GameStageValue.of(Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(20.0f)).clamp(v));
        });
    }
}

