/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.entity.EffectHelper;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.events.type.ICancellableEvent;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.effects.Bleeding;
import com.majruszsdifficulty.events.OnBleedingCheck;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class BleedingDamage {
    static final int DAMAGE_COOLDOWN = TimeHelper.toTicks((double)4.0);
    static final Map<Integer, Integer> ENTITY_TICKS = new HashMap<Integer, Integer>();

    private static void tryToApply(OnEntityDamaged data) {
        if (((OnBleedingCheck)Events.dispatch((ICancellableEvent)new OnBleedingCheck(data))).isBleedingTriggered() && Bleeding.apply(data.target, data.attacker)) {
            BleedingDamage.dealDamage(data.target);
            BleedingDamage.giveAdvancements(data);
        }
    }

    private static void tick(OnEntityTicked data) {
        int amplifier = EffectHelper.getAmplifier(MajruszsDifficulty.BLEEDING_EFFECT, (LivingEntity)data.entity).orElse(0);
        int extraDuration = Random.round((double)(0.3 * (double)(amplifier + 2) * (7.26 * (double)EntityHelper.getWalkDistanceDelta((LivingEntity)data.entity) + 1.0)));
        int duration = ENTITY_TICKS.getOrDefault(data.entity.m_19879_(), 0) + extraDuration;
        if (duration > DAMAGE_COOLDOWN) {
            BleedingDamage.dealDamage(data.entity);
            duration = 0;
        }
        ENTITY_TICKS.put(data.entity.m_19879_(), duration);
    }

    private static void dealDamage(LivingEntity entity) {
        Holder.Reference damageType = entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(MajruszsDifficulty.BLEEDING_DAMAGE_SOURCE);
        MobEffectInstance mobEffectInstance = entity.m_21124_((MobEffect)MajruszsDifficulty.BLEEDING_EFFECT.get());
        if (mobEffectInstance instanceof Bleeding.MobEffectInstance) {
            Bleeding.MobEffectInstance effectInstance = (Bleeding.MobEffectInstance)mobEffectInstance;
            Vec3 motion = entity.m_20184_();
            entity.m_6469_(new DamageSource((Holder)damageType, null, effectInstance.damageSourceEntity), 1.0f);
            entity.m_20256_(motion);
        } else {
            entity.m_6469_(new DamageSource((Holder)damageType), 1.0f);
        }
    }

    private static void giveAdvancements(OnEntityDamaged data) {
        ServerPlayer player;
        LivingEntity livingEntity = data.target;
        if (livingEntity instanceof ServerPlayer) {
            player = (ServerPlayer)livingEntity;
            MajruszsDifficulty.HELPER.triggerAchievement(player, "bleeding_received");
            if (data.source.m_276093_(DamageTypes.f_268585_)) {
                MajruszsDifficulty.HELPER.triggerAchievement(player, "cactus_bleeding");
            }
        }
        if ((livingEntity = data.attacker) instanceof ServerPlayer) {
            player = (ServerPlayer)livingEntity;
            MajruszsDifficulty.HELPER.triggerAchievement(player, "bleeding_inflicted");
        }
    }

    static {
        OnEntityDamaged.listen(BleedingDamage::tryToApply).addCondition(Condition.isLogicalServer()).addCondition(Bleeding::isEnabled).addCondition(data -> Bleeding.canApplyTo(data.target));
        OnEntityTicked.listen(BleedingDamage::tick).addCondition(Condition.isLogicalServer()).addCondition(data -> EffectHelper.has(MajruszsDifficulty.BLEEDING_EFFECT, (LivingEntity)data.entity));
    }
}

