/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.blocks;

import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnBlockPlaced;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Random;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.blocks.InfernalSponge;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;

public class SoakedInfernalSponge
extends Block {
    public SoakedInfernalSponge() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283820_).m_60978_(0.6f).m_60918_(SoundType.f_56740_).m_60953_(x -> 13));
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block neighbor, BlockPos neighborPos, boolean p_56806_) {
        SoakedInfernalSponge.tryToConvert(level, blockPos);
        super.m_6861_(blockState, level, blockPos, neighbor, neighborPos, p_56806_);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        Direction direction = (Direction)Random.next(List.of(Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST));
        BlockPos offsetPos = blockPos.m_121945_(direction);
        if (!blockState.m_60815_() || !level.m_8055_(offsetPos).m_60783_((BlockGetter)level, offsetPos, direction.m_122424_())) {
            double x = blockPos.m_123341_();
            double y = blockPos.m_123342_();
            double z = blockPos.m_123343_();
            if (direction == Direction.DOWN) {
                y -= 0.05;
                x += random.m_188500_();
                z += random.m_188500_();
            } else {
                y += random.m_188500_() * 0.8;
                if (direction.m_122434_() == Direction.Axis.X) {
                    z += random.m_188500_();
                    x = direction == Direction.EAST ? (x += 1.0) : (x += 0.05);
                } else {
                    x += random.m_188500_();
                    z = direction == Direction.SOUTH ? (z += 1.0) : (z += 0.05);
                }
            }
            SimpleParticleType particle = level.m_8055_(offsetPos).m_60713_(Blocks.f_49990_) ? ParticleTypes.f_123762_ : ParticleTypes.f_123800_;
            level.m_7106_((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        LivingEntity livingEntity;
        if (!entity.m_20161_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)(livingEntity = (LivingEntity)entity))) {
            entity.m_6469_(level.m_269111_().m_269047_(), 1.0f);
        }
        super.m_141947_(level, blockPos, blockState, entity);
    }

    private static void tryToConvert(OnBlockPlaced data) {
        SoakedInfernalSponge.tryToConvert((Level)data.getServerLevel(), data.position);
    }

    private static void tryToConvert(Level level, BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            FluidState fluidState = level.m_6425_(blockPos.m_121945_(direction));
            if (!fluidState.m_192917_((Fluid)Fluids.f_76193_) && !fluidState.m_192917_((Fluid)Fluids.f_76192_)) continue;
            level.m_7731_(blockPos, ((InfernalSponge)((Object)MajruszsDifficulty.INFERNAL_SPONGE_BLOCK.get())).m_49966_(), 2);
            SoundEmitter.of((SoundEvent)SoundEvents.f_12031_).position(blockPos.m_252807_()).emit(level);
            break;
        }
    }

    static {
        OnBlockPlaced.listen(SoakedInfernalSponge::tryToConvert).addCondition(Condition.isLogicalServer()).addCondition(data -> data.blockState.m_60713_((Block)MajruszsDifficulty.SOAKED_INFERNAL_SPONGE_BLOCK.get()));
    }

    public static class Item
    extends BlockItem {
        public Item() {
            super((Block)MajruszsDifficulty.SOAKED_INFERNAL_SPONGE_BLOCK.get(), new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41486_());
        }
    }
}

