/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.recipe;

import cn.mcmod_mmf.mmlib.recipe.AbstractRecipe;
import cn.mcmod_mmf.mmlib.utils.DataGenUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AbstractRecipeSerializer<T extends AbstractRecipe>
implements RecipeSerializer<T> {
    private final Class<T> recipeClass;

    public AbstractRecipeSerializer(Class<T> recipeClass) {
        this.recipeClass = recipeClass;
    }

    public T fromJson(ResourceLocation recipeID, JsonObject recipeJson) {
        AbstractRecipe result = (AbstractRecipe)DataGenUtil.NETWORK_GSON.fromJson((JsonElement)recipeJson, this.recipeClass);
        result.setId(recipeID);
        return (T)result;
    }

    public T fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
        AbstractRecipe result = (AbstractRecipe)DataGenUtil.NETWORK_GSON.fromJson(buffer.m_130277_(), this.recipeClass);
        result.setId(recipeID);
        return (T)result;
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        buffer.m_130070_(DataGenUtil.NETWORK_GSON.toJson(recipe));
    }

    public JsonObject toJson(T recipe) {
        return DataGenUtil.NETWORK_GSON.toJsonTree(recipe).getAsJsonObject();
    }
}

