/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.attributefilter;

import com.hlysine.create_connected.CCItemAttributes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemStackCountAttribute
implements ItemAttribute {
    int stackSize;

    public ItemStackCountAttribute(int stackSize) {
        this.stackSize = stackSize;
    }

    public boolean appliesTo(ItemStack stack, Level world) {
        return stack.m_41741_() == this.stackSize;
    }

    public ItemAttributeType getType() {
        return CCItemAttributes.STACK_SIZE;
    }

    public String getTranslationKey() {
        return "stack_size";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{String.valueOf(this.stackSize)};
    }

    public void save(CompoundTag nbt) {
        nbt.m_128405_("stackCount", this.stackSize);
    }

    public void load(CompoundTag nbt) {
        this.stackSize = nbt.m_128451_("stackCount");
    }

    public static class LegacyDeserializer
    implements ItemAttribute.LegacyDeserializer {
        public String getNBTKey() {
            return "stackSize";
        }

        public ItemAttribute readNBT(CompoundTag nbt) {
            ItemStackCountAttribute attribute = new ItemStackCountAttribute(0);
            attribute.load(nbt);
            return attribute;
        }
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new ItemStackCountAttribute(64);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            attributes.add(new ItemStackCountAttribute(stack.m_41741_()));
            return attributes;
        }
    }
}

