/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CloneCommand {
    private static final Dynamic2CommandExceptionType CLONE_TOO_BIG_EXCEPTION = new Dynamic2CommandExceptionType((arg1, arg2) -> Component.m_237110_((String)"commands.clone.toobig", (Object[])new Object[]{arg1, arg2}));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clone").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"begin", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"end", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"destination", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"skipBlocks").executes(ctx -> CloneCommand.doClone((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"begin"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"end"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"destination"), false)))).executes(ctx -> CloneCommand.doClone((CommandSourceStack)ctx.getSource(), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"begin"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"end"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"destination"), true)))))).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Clones all blocks as well as super glue from the specified area to the target destination"), true);
            return 1;
        });
    }

    private static int doClone(CommandSourceStack source, BlockPos begin, BlockPos end, BlockPos destination, boolean cloneBlocks) throws CommandSyntaxException {
        int limit;
        BoundingBox sourceArea = BoundingBox.m_162375_((Vec3i)begin, (Vec3i)end);
        BlockPos destinationEnd = destination.m_121955_(sourceArea.m_71053_());
        BoundingBox destinationArea = BoundingBox.m_162375_((Vec3i)destination, (Vec3i)destinationEnd);
        ServerLevel world = source.m_81372_();
        int i = sourceArea.m_71056_() * sourceArea.m_71057_() * sourceArea.m_71058_();
        if (i > (limit = world.m_46469_().m_46215_(GameRules.f_263760_))) {
            throw CLONE_TOO_BIG_EXCEPTION.create((Object)limit, (Object)i);
        }
        if (!world.m_46832_(begin, end) || !world.m_46832_(destination, destinationEnd)) {
            throw BlockPosArgument.f_118234_.create();
        }
        BlockPos diffToTarget = new BlockPos(destinationArea.m_162395_() - sourceArea.m_162395_(), destinationArea.m_162396_() - sourceArea.m_162396_(), destinationArea.m_162398_() - sourceArea.m_162398_());
        int blockPastes = cloneBlocks ? CloneCommand.cloneBlocks(sourceArea, world, diffToTarget) : 0;
        int gluePastes = CloneCommand.cloneGlue(sourceArea, world, diffToTarget);
        if (cloneBlocks) {
            source.m_288197_(() -> Component.m_237113_((String)("Successfully cloned " + blockPastes + " Blocks")), true);
        }
        source.m_288197_(() -> Component.m_237113_((String)("Successfully applied glue " + gluePastes + " times")), true);
        return blockPastes + gluePastes;
    }

    private static int cloneGlue(BoundingBox sourceArea, ServerLevel world, BlockPos diffToTarget) {
        int gluePastes = 0;
        AABB bb = new AABB((double)sourceArea.m_162395_(), (double)sourceArea.m_162396_(), (double)sourceArea.m_162398_(), (double)(sourceArea.m_162399_() + 1), (double)(sourceArea.m_162400_() + 1), (double)(sourceArea.m_162401_() + 1));
        for (SuperGlueEntity g : SuperGlueEntity.collectCropped((Level)world, bb)) {
            g.m_146884_(g.m_20182_().m_82549_(Vec3.m_82528_((Vec3i)diffToTarget)));
            world.m_7967_((Entity)g);
            ++gluePastes;
        }
        return gluePastes;
    }

    private static int cloneBlocks(BoundingBox sourceArea, ServerLevel world, BlockPos diffToTarget) {
        BlockEntity be;
        int blockPastes = 0;
        ArrayList blocks = Lists.newArrayList();
        ArrayList beBlocks = Lists.newArrayList();
        for (int z = sourceArea.m_162398_(); z <= sourceArea.m_162401_(); ++z) {
            for (int y = sourceArea.m_162396_(); y <= sourceArea.m_162400_(); ++y) {
                for (int x = sourceArea.m_162395_(); x <= sourceArea.m_162399_(); ++x) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockPos newPos = currentPos.m_121955_((Vec3i)diffToTarget);
                    BlockInWorld cached = new BlockInWorld((LevelReader)world, currentPos, false);
                    BlockState state = cached.m_61168_();
                    BlockEntity be2 = world.m_7702_(currentPos);
                    if (be2 != null) {
                        CompoundTag nbt = be2.m_187480_();
                        beBlocks.add(new StructureTemplate.StructureBlockInfo(newPos, state, nbt));
                        continue;
                    }
                    blocks.add(new StructureTemplate.StructureBlockInfo(newPos, state, null));
                }
            }
        }
        ArrayList allBlocks = Lists.newArrayList();
        allBlocks.addAll(blocks);
        allBlocks.addAll(beBlocks);
        List reverse = Lists.reverse((List)allBlocks);
        for (StructureTemplate.StructureBlockInfo info : reverse) {
            be = world.m_7702_(info.f_74675_());
            Clearable.m_18908_((Object)be);
            world.m_7731_(info.f_74675_(), Blocks.f_50375_.m_49966_(), 2);
        }
        for (StructureTemplate.StructureBlockInfo info : allBlocks) {
            if (!world.m_7731_(info.f_74675_(), info.f_74676_(), 2)) continue;
            ++blockPastes;
        }
        for (StructureTemplate.StructureBlockInfo info : beBlocks) {
            be = world.m_7702_(info.f_74675_());
            if (be != null && info.f_74677_() != null) {
                info.f_74677_().m_128405_("x", info.f_74675_().m_123341_());
                info.f_74677_().m_128405_("y", info.f_74675_().m_123342_());
                info.f_74677_().m_128405_("z", info.f_74675_().m_123343_());
                be.m_142466_(info.f_74677_());
                be.m_6596_();
            }
            world.m_7731_(info.f_74675_(), info.f_74676_(), 2);
        }
        for (StructureTemplate.StructureBlockInfo info : reverse) {
            world.m_6289_(info.f_74675_(), info.f_74676_().m_60734_());
        }
        world.m_183326_().m_193242_(sourceArea, (Vec3i)diffToTarget);
        return blockPastes;
    }
}

