/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.funnel.AbstractDirectionalFunnelBlock;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FunnelBlock
extends AbstractDirectionalFunnelBlock {
    public static final BooleanProperty EXTRACTING = BooleanProperty.m_61465_((String)"extracting");

    public FunnelBlock(BlockBehaviour.Properties p_i48415_1_) {
        super(p_i48415_1_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EXTRACTING, (Comparable)Boolean.valueOf(false)));
    }

    public abstract BlockState getEquivalentBeltFunnel(BlockGetter var1, BlockPos var2, BlockState var3);

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        boolean sneak = context.m_43723_() != null && context.m_43723_().m_6144_();
        state = (BlockState)state.m_61124_((Property)EXTRACTING, (Comparable)Boolean.valueOf(!sneak));
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)blockstate.m_61124_((Property)POWERED, (Comparable)((Boolean)state.m_61143_((Property)POWERED)));
        }
        return state;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{EXTRACTING}));
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BeltFunnelBlock bfb;
        Block block = newState.m_60734_();
        if (block instanceof BeltFunnelBlock && (bfb = (BeltFunnelBlock)block).isOfSameType(this)) {
            return;
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean shouldntInsertItem;
        ItemStack heldItem = player.m_21120_(handIn);
        boolean bl = shouldntInsertItem = AllBlocks.MECHANICAL_ARM.isIn(heldItem) || !this.canInsertIntoFunnel(state);
        if (AllItems.WRENCH.isIn(heldItem)) {
            return InteractionResult.PASS;
        }
        if (hit.m_82434_() == FunnelBlock.getFunnelFacing(state) && !shouldntInsertItem) {
            if (!worldIn.f_46443_) {
                this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
                    ItemStack toInsert = heldItem.m_41777_();
                    ItemStack remainder = FunnelBlock.tryInsert(worldIn, pos, toInsert, false);
                    if (!ItemStack.m_41728_((ItemStack)remainder, (ItemStack)toInsert) || remainder.m_41613_() != heldItem.m_41613_()) {
                        player.m_21008_(handIn, remainder);
                    }
                });
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        if (!world.f_46443_) {
            world.m_46597_(context.m_8083_(), (BlockState)state.m_61122_((Property)EXTRACTING));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.f_46443_) {
            return;
        }
        ItemStack stack = ItemHelper.fromItemEntity(entityIn);
        if (stack.m_41619_()) {
            return;
        }
        if (!this.canInsertIntoFunnel(state)) {
            return;
        }
        Direction direction = FunnelBlock.getFunnelFacing(state);
        Vec3 openPos = VecHelper.getCenterOf((Vec3i)pos).m_82549_(Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_(entityIn instanceof ItemEntity ? -0.25 : -0.125));
        Vec3 diff = entityIn.m_20182_().m_82546_(openPos);
        double projectedDiff = direction.m_122434_().m_6150_(diff.f_82479_, diff.f_82480_, diff.f_82481_);
        if (projectedDiff < 0.0 == (direction.m_122421_() == Direction.AxisDirection.POSITIVE)) {
            return;
        }
        float yOffset = direction == Direction.UP ? 0.25f : (direction == Direction.DOWN ? -0.5f : -0.5f);
        FilteringBehaviour filter = BlockEntityBehaviour.get((BlockGetter)worldIn, pos, FilteringBehaviour.TYPE);
        if (filter.test(stack) && !PackageEntity.centerPackage(entityIn, openPos.m_82520_(0.0, (double)yOffset, 0.0))) {
            return;
        }
        ItemStack remainder = FunnelBlock.tryInsert(worldIn, pos, stack, false);
        if (remainder.m_41619_()) {
            entityIn.m_146870_();
        }
        if (remainder.m_41613_() < stack.m_41613_() && entityIn instanceof ItemEntity) {
            ((ItemEntity)entityIn).m_32045_(remainder);
        }
    }

    protected boolean canInsertIntoFunnel(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED) == false && (Boolean)state.m_61143_((Property)EXTRACTING) == false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return facing == Direction.DOWN ? AllShapes.FUNNEL_CEILING : (facing == Direction.UP ? AllShapes.FUNNEL_FLOOR : AllShapes.FUNNEL_WALL.get(facing));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext && ((EntityCollisionContext)context).m_193113_() instanceof ItemEntity && this.getFacing(state).m_122434_().m_122479_()) {
            return AllShapes.FUNNEL_COLLISION.get(this.getFacing(state));
        }
        return this.m_5940_(state, world, pos, context);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState p_196271_3_, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        this.updateWater(world, state, pos);
        if (this.getFacing(state).m_122434_().m_122478_() || direction != Direction.DOWN) {
            return state;
        }
        BlockState equivalentFunnel = ProperWaterloggedBlock.withWater(world, this.getEquivalentBeltFunnel(null, null, state), pos);
        if (BeltFunnelBlock.isOnValidBelt(equivalentFunnel, (LevelReader)world, pos)) {
            return (BlockState)equivalentFunnel.m_61124_(BeltFunnelBlock.SHAPE, (Comparable)((Object)BeltFunnelBlock.getShapeForPosition((BlockGetter)world, pos, this.getFacing(state), (Boolean)state.m_61143_((Property)EXTRACTING))));
        }
        return state;
    }
}

