/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.smoke;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rbasamoyai.createbigcannons.effects.particles.smoke.CannonSmokeParticle;
import rbasamoyai.createbigcannons.index.CBCParticleTypes;

public class CannonSmokeParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<CannonSmokeParticleData> {
    public static final Codec<CannonSmokeParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("power").forGetter(data -> Float.valueOf(data.power)), (App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size)), (App)Codec.INT.fieldOf("lifetime").forGetter(data -> data.lifetime), (App)Codec.FLOAT.fieldOf("friction").forGetter(data -> Float.valueOf(data.friction))).apply((Applicative)i, CannonSmokeParticleData::new));
    public static final ParticleOptions.Deserializer<CannonSmokeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<CannonSmokeParticleData>(){

        public CannonSmokeParticleData fromNetwork(ParticleType<CannonSmokeParticleData> type, FriendlyByteBuf buf) {
            float power = buf.readFloat();
            float size = buf.readFloat();
            int lifetime = buf.m_130242_();
            float friction = buf.readFloat();
            return new CannonSmokeParticleData(power, size, lifetime, friction);
        }

        public CannonSmokeParticleData fromCommand(ParticleType<CannonSmokeParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float power = reader.readFloat();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            float friction = reader.readFloat();
            return new CannonSmokeParticleData(power, size, lifetime, friction);
        }
    };
    private final float power;
    private final float size;
    private final int lifetime;
    private final float friction;

    public CannonSmokeParticleData(float power, float size, int lifetime, float friction) {
        this.power = power;
        this.size = size;
        this.lifetime = lifetime;
        this.friction = friction;
    }

    public CannonSmokeParticleData() {
        this(0.0f, 1.0f, 1, 1.0f);
    }

    public float power() {
        return this.power;
    }

    public float size() {
        return this.size;
    }

    public int lifetime() {
        return this.lifetime;
    }

    public float friction() {
        return this.friction;
    }

    public ParticleType<?> m_6012_() {
        return CBCParticleTypes.CANNON_SMOKE.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.power).writeFloat(this.size);
        buf.m_130130_(this.lifetime).writeFloat(this.friction);
    }

    public String m_5942_() {
        return String.format("%f %f %d %f", Float.valueOf(this.power), Float.valueOf(this.size), this.lifetime, Float.valueOf(this.friction));
    }

    public ParticleOptions.Deserializer<CannonSmokeParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<CannonSmokeParticleData> getCodec(ParticleType<CannonSmokeParticleData> type) {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<CannonSmokeParticleData> getMetaFactory() {
        return CannonSmokeParticle.Provider::new;
    }
}

