/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.breeches.screw_breech;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.screw_breech.ScrewBreechBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.cannon_end.BigCannonEnd;

public class ScrewBreechBlockEntity
extends KineticBlockEntity
implements IBigCannonBlockEntity {
    private BigCannonBehavior cannonBehavior;
    private float openProgress;

    public ScrewBreechBlockEntity(BlockEntityType<? extends ScrewBreechBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.cannonBehavior = new BigCannonBehavior((SmartBlockEntity)this, this::canLoadBlock);
        behaviours.add(this.cannonBehavior);
    }

    @Override
    public boolean canLoadBlock(StructureTemplate.StructureBlockInfo blockInfo) {
        return false;
    }

    @Override
    public BigCannonBehavior cannonBehavior() {
        return this.cannonBehavior;
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        float progress = this.getOpeningSpeed();
        if (Math.abs(progress) > 0.0f) {
            this.openProgress = Mth.m_14036_((float)(this.openProgress + progress), (float)0.0f, (float)1.0f);
        }
        if (this.m_58904_() != null && !this.m_58904_().f_46443_) {
            BigCannonEnd openState = (BigCannonEnd)((Object)this.m_58900_().m_61143_(ScrewBreechBlock.OPEN));
            Direction facing = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
            if (this.openProgress <= 0.0f && openState != BigCannonEnd.CLOSED) {
                this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ScrewBreechBlock.OPEN, (Comparable)((Object)BigCannonEnd.CLOSED)), 3);
                this.cannonBehavior.setConnectedFace(facing, true);
                this.m_6596_();
                BlockEntity be = this.m_58904_().m_7702_(this.f_58858_.m_121945_(facing));
                if (be instanceof IBigCannonBlockEntity) {
                    IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
                    ((BigCannonBehavior)((Object)cbe.cannonBehavior())).setConnectedFace(facing.m_122424_(), true);
                    be.m_6596_();
                }
            } else if (this.openProgress >= 1.0f && openState != BigCannonEnd.OPEN) {
                this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ScrewBreechBlock.OPEN, (Comparable)((Object)BigCannonEnd.OPEN)), 3);
                this.cannonBehavior.setConnectedFace(facing, false);
                this.m_6596_();
                BlockEntity be = this.m_58904_().m_7702_(this.f_58858_.m_121945_(facing));
                if (be instanceof IBigCannonBlockEntity) {
                    IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
                    ((BigCannonBehavior)((Object)cbe.cannonBehavior())).setConnectedFace(facing.m_122424_(), false);
                    be.m_6596_();
                }
            } else if (this.openProgress > 0.0f && this.openProgress < 1.0f && openState != BigCannonEnd.PARTIAL) {
                boolean previouslyConnected = this.cannonBehavior.isConnectedTo(facing);
                this.m_58904_().m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ScrewBreechBlock.OPEN, (Comparable)((Object)BigCannonEnd.PARTIAL)), 3);
                this.cannonBehavior.setConnectedFace(facing, previouslyConnected);
                BlockEntity be = this.m_58904_().m_7702_(this.f_58858_.m_121945_(facing));
                if (be instanceof IBigCannonBlockEntity) {
                    IBigCannonBlockEntity cbe = (IBigCannonBlockEntity)be;
                    ((BigCannonBehavior)((Object)cbe.cannonBehavior())).setConnectedFace(facing.m_122424_(), previouslyConnected);
                    be.m_6596_();
                }
            }
        }
    }

    public float getOpeningSpeed() {
        return Math.abs(this.getSpeed()) > 0.0f ? this.getSpeed() / 512.0f : 0.0f;
    }

    public float getRenderedBlockOffset(float partialTicks) {
        return Mth.m_14036_((float)(this.openProgress + this.getOpeningSpeed() * partialTicks), (float)0.0f, (float)1.0f);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("Progress", this.openProgress);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.openProgress = compound.m_128457_("Progress");
    }
}

