/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells;

import io.redspace.ironsspellbooks.api.events.SpellHealEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class HealingAoe
extends AoeEntity
implements AntiMagicSusceptible {
    public HealingAoe(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public HealingAoe(Level level) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.HEALING_AOE.get()), level);
    }

    @Override
    public void applyEffect(LivingEntity target) {
        LivingEntity owner;
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity && Utils.shouldHealEntity(owner = (LivingEntity)entity, target)) {
            float healAmount = this.getDamage();
            MinecraftForge.EVENT_BUS.post((Event)new SpellHealEvent((LivingEntity)this.m_19749_(), target, healAmount, (SchoolType)SchoolRegistry.HOLY.get()));
            target.m_5634_(healAmount);
        }
    }

    @Override
    protected boolean m_5603_(Entity pTarget) {
        return !pTarget.m_5833_() && pTarget.m_6084_() && pTarget.m_6087_();
    }

    @Override
    public float getParticleCount() {
        return 0.15f;
    }

    @Override
    public void ambientParticles() {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        int color = PotionUtils.m_43559_((Potion)Potion.m_43489_((String)"healing"));
        double d0 = (double)(color >> 16 & 0xFF) / 255.0;
        double d1 = (double)(color >> 8 & 0xFF) / 255.0;
        double d2 = (double)(color >> 0 & 0xFF) / 255.0;
        float f = this.getParticleCount();
        f = Mth.m_14036_((float)(f * this.getRadius()), (float)(f / 4.0f), (float)(f * 10.0f));
        int i = 0;
        while ((float)i < f) {
            Vec3 pos;
            if (f - (float)i < 1.0f && this.f_19796_.m_188501_() > f - (float)i) {
                return;
            }
            float r = this.getRadius();
            if (this.isCircular().booleanValue()) {
                float distance = (1.0f - this.f_19796_.m_188501_() * this.f_19796_.m_188501_()) * r;
                pos = new Vec3(0.0, 0.0, (double)distance).m_82524_(this.f_19796_.m_188501_() * 360.0f);
            } else {
                pos = new Vec3(Utils.getRandomScaled(r * 0.85f), (double)0.2f, Utils.getRandomScaled(r * 0.85f));
            }
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + pos.f_82479_, this.m_20186_() + pos.f_82480_ + (double)this.particleYOffset(), this.m_20189_() + pos.f_82481_, d0, d1, d2);
            ++i;
        }
    }

    @Override
    protected Vec3 getInflation() {
        return new Vec3(0.0, 1.0, 0.0);
    }

    @Override
    public Optional<ParticleOptions> getParticle() {
        return Optional.empty();
    }

    @Override
    public void onAntiMagic(MagicData magicData) {
        this.m_146870_();
    }
}

