/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.container;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.container.TANContainerTypes;
import toughasnails.block.entity.ThermoregulatorBlockEntity;
import toughasnails.container.ThermoregulatorCoolingFuelSlot;
import toughasnails.container.ThermoregulatorHeatingFuelSlot;

public class ThermoregulatorContainer
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    private final Level level;

    public ThermoregulatorContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(2));
    }

    public ThermoregulatorContainer(int id, Inventory playerInventory, Container container, ContainerData data) {
        super(TANContainerTypes.THERMOREGULATOR, id);
        this.container = container;
        this.data = data;
        this.level = playerInventory.f_35978_.m_9236_();
        this.m_38897_(new ThermoregulatorCoolingFuelSlot(container, 0, 44, 42));
        this.m_38897_(new ThermoregulatorHeatingFuelSlot(container, 1, 116, 42));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.m_38897_(new Slot((Container)playerInventory, slot, 8 + slot * 18, 142));
        }
        this.m_38884_(data);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack prevItem = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            prevItem = slotItem.m_41777_();
            if (index != 1 && index != 0 ? (ThermoregulatorBlockEntity.isCoolingFuel(slotItem) ? !this.m_38903_(slotItem, 0, 1, false) : (ThermoregulatorBlockEntity.isHeatingFuel(slotItem) ? !this.m_38903_(slotItem, 1, 2, false) : (index >= 2 && index < 30 ? !this.m_38903_(slotItem, 30, 38, false) : index >= 30 && index < 38 && !this.m_38903_(slotItem, 2, 30, false)))) : !this.m_38903_(slotItem, 2, 38, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == prevItem.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotItem);
        }
        return prevItem;
    }

    public int getCoolingFuelProgress() {
        return this.data.m_6413_(0) * 13 / 1600;
    }

    public int getHeatingFuelProgress() {
        return this.data.m_6413_(1) * 13 / 1600;
    }

    public boolean isCooling() {
        return this.data.m_6413_(0) > 0;
    }

    public boolean isHeating() {
        return this.data.m_6413_(1) > 0;
    }
}

