/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.shieldexp.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import org.infernalstudios.shieldexp.init.ShieldDataLoader;

public class SyncShields {
    private static final int MAX = 65534;
    JsonElement data;
    ResourceLocation shield;

    public SyncShields(FriendlyByteBuf buf) {
        this.shield = buf.m_130281_();
        this.data = (JsonElement)GsonHelper.m_13794_((Gson)ShieldDataLoader.GSON, (String)buf.m_130136_(65534), JsonElement.class);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.shield);
        buf.m_130070_(this.data.toString());
    }

    public SyncShields(ResourceLocation shield, JsonElement data) {
        this.shield = shield;
        this.data = data;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::handle);
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handle() {
        ShieldDataLoader.parse(this.shield, this.data.getAsJsonObject());
    }
}

