/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.shieldexp.mixin;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.infernalstudios.shieldexp.access.LivingEntityAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements LivingEntityAccess {
    @Unique
    private static final EntityDataAccessor<Integer> PARRY_COOLDOWN = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Integer> BLOCKED_COOLDOWN = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Integer> USED_STAMINA = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<ItemStack> LAST_SHIELD = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @Unique
    private static final EntityDataAccessor<Boolean> IS_BLOCKING = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void shieldexp$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(PARRY_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(BLOCKED_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(USED_STAMINA, (Object)0);
        this.f_19804_.m_135372_(LAST_SHIELD, (Object)new ItemStack((ItemLike)Items.f_41852_));
        this.f_19804_.m_135372_(IS_BLOCKING, (Object)false);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void shieldexp$tick(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            if (this.getParryWindow() > 0) {
                this.setParryWindow(this.getParryWindow() - 1);
            }
            if (this.getBlockedCooldown() > 0) {
                this.setBlockedCooldown(this.getBlockedCooldown() - 1);
            }
        }
    }

    @Override
    public int getParryWindow() {
        return (Integer)this.f_19804_.m_135370_(PARRY_COOLDOWN);
    }

    @Override
    public void setParryWindow(int parry) {
        this.f_19804_.m_135381_(PARRY_COOLDOWN, (Object)parry);
    }

    @Override
    public int getBlockedCooldown() {
        return (Integer)this.f_19804_.m_135370_(BLOCKED_COOLDOWN);
    }

    @Override
    public boolean getBlocking() {
        return (Boolean)this.f_19804_.m_135370_(IS_BLOCKING);
    }

    @Override
    public void setBlockedCooldown(int block) {
        this.f_19804_.m_135381_(BLOCKED_COOLDOWN, (Object)block);
    }

    @Override
    public void setBlocking(boolean bool) {
        this.f_19804_.m_135381_(IS_BLOCKING, (Object)bool);
    }

    @Override
    public int getUsedStamina() {
        return (Integer)this.f_19804_.m_135370_(USED_STAMINA);
    }

    @Override
    public void setUsedStamina(int stamina) {
        this.f_19804_.m_135381_(USED_STAMINA, (Object)stamina);
    }

    @Override
    public ItemStack getLastShield() {
        return (ItemStack)this.f_19804_.m_135370_(LAST_SHIELD);
    }

    @Override
    public void setLastShield(ItemStack shield) {
        this.f_19804_.m_135381_(LAST_SHIELD, (Object)shield);
    }
}

