/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.shieldexp;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infernalstudios.shieldexp.compat.BetterCombatAttackListener;
import org.infernalstudios.shieldexp.events.ClientEvents;
import org.infernalstudios.shieldexp.events.CreativeTabEvents;
import org.infernalstudios.shieldexp.events.ShieldExpansionEvents;
import org.infernalstudios.shieldexp.init.Config;
import org.infernalstudios.shieldexp.init.ItemsInit;
import org.infernalstudios.shieldexp.init.NetworkInit;
import org.infernalstudios.shieldexp.init.ShieldDataLoader;
import org.infernalstudios.shieldexp.init.SoundsInit;

@Mod(value="shieldexp")
public class ShieldExpansion {
    public static final String NAME = "Shield Expansion";
    public static final String MOD_ID = "shieldexp";
    public static final Logger LOGGER = LogManager.getLogger((String)"Shield Expansion");

    public ShieldExpansion() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemsInit.ITEMS.register(modBus);
        SoundsInit.SOUND_EVENTS.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.CONFIG, "ShieldExpansion-common.toml");
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::commonSetup);
        modBus.addListener(CreativeTabEvents::addShields);
        MinecraftForge.EVENT_BUS.register((Object)new ShieldExpansionEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ShieldDataLoader());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::setup);
        if (ModList.get().isLoaded("bettercombat")) {
            BetterCombatAttackListener.register();
        }
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        NetworkInit.registerPackets();
    }
}

