/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.CooldownPowerFactory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface HarmActionPowerFactory<P>
extends CooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return CooldownPowerFactory.getSerializableData().add("entity_action", Services.ACTION.entityDataType(), null).add("bientity_action", Services.ACTION.biEntityDataType(), null).add("damage_condition", Services.CONDITION.damageDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("amount_to_trigger", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("overflow", SerializableDataTypes.BOOLEAN, (Object)false).add("limit", SerializableDataTypes.FLOAT, (Object)Float.valueOf(Float.NaN));
    }

    default public void execute(P power, LivingEntity powerHolder, DamageSource source, float amount, Entity attacker, LivingEntity target) {
        SerializableData.Instance data = this.getDataFromPower(power);
        if (this.canUse(power, (Entity)powerHolder) && Services.CONDITION.checkDamage(data, "damage_condition", source, amount) && Services.CONDITION.checkBiEntity(data, "bientity_condition", attacker, (Entity)target)) {
            float triggerTimes = data.getBoolean("overflow") ? amount / data.getFloat("amount_to_trigger") : Math.min(target.m_21223_(), amount) / data.getFloat("amount_to_trigger");
            float limit = data.getFloat("limit");
            int i = 0;
            while (true) {
                float f = i;
                float f2 = Float.isNaN(limit) ? target.m_21233_() * 4.0f : limit;
                if (!(f < Math.min(triggerTimes, f2))) break;
                Services.ACTION.executeEntity(data, "entity_action", (Entity)powerHolder);
                if (attacker != null && target != null) {
                    Services.ACTION.executeBiEntity(data, "bientity_action", attacker, (Entity)target);
                }
                ++i;
            }
            this.use(power, (Entity)powerHolder);
        }
    }
}

