/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.CooldownPowerFactory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface ActionOnTargetDeathPowerFactory<P>
extends CooldownPowerFactory<P> {
    public static SerializableData getSerializableData() {
        return CooldownPowerFactory.getSerializableData().add("bientity_action", Services.ACTION.biEntityDataType()).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("damage_condition", Services.CONDITION.damageDataType(), null).add("includes_prime_adversary", SerializableDataTypes.BOOLEAN, (Object)true);
    }

    default public void onTargetDeath(LivingEntity actor, Entity target, DamageSource damageSource, float damageAmount, boolean primeAdversary) {
        for (Object power : Services.POWER.getPowers(actor, this).stream().filter(p -> !primeAdversary || this.getDataFromPower(p).getBoolean("includes_prime_adversary")).toList()) {
            SerializableData.Instance data;
            if (!this.canUse(power, (Entity)actor) || !Services.CONDITION.checkBiEntity(data = this.getDataFromPower(power), "bientity_condition", (Entity)actor, target) || !Services.CONDITION.checkDamage(data, "damage_condition", damageSource, damageAmount)) continue;
            Services.ACTION.executeBiEntity(data, "bientity_action", (Entity)actor, target);
            this.use(power, (Entity)actor);
        }
    }
}

