/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ClientActionOverTime
extends Power {
    private final int interval;
    private final Consumer<Entity> entityAction;
    private final Consumer<Entity> risingAction;
    private final Consumer<Entity> fallingAction;
    private boolean wasActive = false;
    private Integer initialTicks = null;

    public ClientActionOverTime(PowerType<?> type, LivingEntity entity, Consumer<Entity> entityAction, Consumer<Entity> risingAction, Consumer<Entity> fallingAction, int interval) {
        super(type, entity);
        this.entityAction = entityAction;
        this.risingAction = risingAction;
        this.fallingAction = fallingAction;
        this.interval = interval;
    }

    public void clientTick() {
        if (this.initialTicks == null) {
            this.initialTicks = this.entity.f_19797_ % this.interval;
        } else if (this.entity.f_19797_ % this.interval == this.initialTicks) {
            if (this.isActive()) {
                if (!this.wasActive && this.risingAction != null) {
                    this.risingAction.accept((Entity)this.entity);
                }
                if (this.entityAction != null) {
                    this.entityAction.accept((Entity)this.entity);
                }
                this.wasActive = true;
            } else {
                if (this.wasActive && this.fallingAction != null) {
                    this.fallingAction.accept((Entity)this.entity);
                }
                this.wasActive = false;
            }
        }
    }

    public static class Factory
    extends SimplePowerFactory<ClientActionOverTime> {
        public Factory() {
            super("client_action_over_time", new SerializableData().add("entity_action", Services.ACTION.entityDataType(), null).add("rising_action", Services.ACTION.entityDataType(), null).add("falling_action", Services.ACTION.entityDataType(), null).add("interval", SerializableDataTypes.INT, (Object)20), data -> (type, entity) -> new ClientActionOverTime((PowerType<?>)type, (LivingEntity)entity, Services.ACTION.entityConsumer((SerializableData.Instance)data, "entity_action"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "rising_action"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "falling_action"), data.getInt("interval")));
            this.allowCondition();
        }

        @Override
        public Class<ClientActionOverTime> getPowerClass() {
            return ClientActionOverTime.class;
        }
    }
}

