/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform;

import com.google.auto.service.AutoService;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.apoli.util.ResourceOperation;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredModifier;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.ModelColorPower;
import io.github.edwinmindcraft.apoli.common.power.configuration.ColorConfiguration;
import io.github.edwinmindcraft.apoli.common.registry.ApoliPowers;
import java.util.List;
import java.util.Optional;
import net.merchantpug.apugli.capability.entity.HitsOnTargetCapability;
import net.merchantpug.apugli.capability.entity.KeyPressCapability;
import net.merchantpug.apugli.data.ApoliForgeDataTypes;
import net.merchantpug.apugli.network.ApugliPacketHandler;
import net.merchantpug.apugli.network.c2s.ApugliPacketC2S;
import net.merchantpug.apugli.network.s2c.AddKeyToCheckPacket;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.network.s2c.ForcePlayerPosePacket;
import net.merchantpug.apugli.network.s2c.SyncHitsOnTargetLessenedPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.platform.services.IPlatformHelper;
import net.merchantpug.apugli.util.ActiveKeyUtil;
import net.merchantpug.apugli.util.HudRenderUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.extensions.IForgePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

@AutoService(value={IPlatformHelper.class})
public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public double getReachDistance(Entity entity) {
        double d;
        if (entity instanceof IForgePlayer) {
            IForgePlayer player = (IForgePlayer)entity;
            d = player.getBlockReach();
        } else {
            d = 4.5;
        }
        return d;
    }

    @Override
    public double getAttackRange(Entity entity) {
        double d;
        if (entity instanceof IForgePlayer) {
            IForgePlayer player = (IForgePlayer)entity;
            d = player.getEntityReach();
        } else {
            d = 3.0;
        }
        return d;
    }

    public SerializableDataType<IActivePower.Key> getKeyDataType() {
        return ApoliForgeDataTypes.KEY;
    }

    public SerializableDataType<ConfiguredModifier<?>> getModifierDataType() {
        return ApoliForgeDataTypes.MODIFIER;
    }

    public SerializableDataType<List<ConfiguredModifier<?>>> getModifiersDataType() {
        return SerializableDataType.list(ApoliForgeDataTypes.MODIFIER);
    }

    @Override
    public double applyModifiers(Entity entity, List<?> modifiers, double value) {
        if (modifiers.stream().anyMatch(o -> o instanceof ConfiguredModifier)) {
            return ModifierUtil.applyModifiers((Entity)entity, modifiers, (double)value);
        }
        return value;
    }

    @Override
    public void sendS2C(ApugliPacketS2C packet, ServerPlayer player) {
        ApugliPacketHandler.sendS2C(packet, player);
    }

    @Override
    public void sendS2CTrackingAndSelf(ApugliPacketS2C packet, Entity entity) {
        ApugliPacketHandler.sendS2CTrackingAndSelf(packet, entity);
    }

    @Override
    public void sendC2S(ApugliPacketC2S packet) {
        ApugliPacketHandler.sendC2S(packet);
    }

    @Override
    public int compareModifiers(Object modifier, Object otherModifier) {
        return Integer.compare(this.compareModifiersInternal((ConfiguredModifier)modifier, (ConfiguredModifier)otherModifier), this.compareModifiersInternal((ConfiguredModifier)otherModifier, (ConfiguredModifier)modifier));
    }

    private int compareModifiersInternal(ConfiguredModifier<?> modifier, ConfiguredModifier<?> otherModifier) {
        if (modifier.getFactory() == otherModifier.getFactory()) {
            return 0;
        }
        if (modifier.getFactory().getPhase() == otherModifier.getFactory().getPhase()) {
            return modifier.getFactory().getOrder() - otherModifier.getFactory().getOrder();
        }
        return modifier.getFactory().getPhase().ordinal() - otherModifier.getFactory().getPhase().ordinal();
    }

    @Override
    public float[] getColorPowerRgba(LivingEntity entity) {
        List modelColorPowers = IPowerContainer.getPowers((Entity)entity, (PowerFactory)((ModelColorPower)ApoliPowers.MODEL_COLOR.get()));
        if (modelColorPowers.size() > 0) {
            float red = modelColorPowers.stream().map(holder -> Float.valueOf(((ColorConfiguration)((ConfiguredPower)holder.get()).getConfiguration()).red())).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float green = modelColorPowers.stream().map(holder -> Float.valueOf(((ColorConfiguration)((ConfiguredPower)holder.get()).getConfiguration()).green())).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float blue = modelColorPowers.stream().map(holder -> Float.valueOf(((ColorConfiguration)((ConfiguredPower)holder.get()).getConfiguration()).blue())).reduce((a, c) -> Float.valueOf(a.floatValue() * c.floatValue())).get().floatValue();
            float alpha = modelColorPowers.stream().map(holder -> Float.valueOf(((ColorConfiguration)((ConfiguredPower)holder.get()).getConfiguration()).alpha())).min(Float::compare).get().floatValue();
            return new float[]{red, green, blue, alpha};
        }
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public void updateKeys(SerializableData.Instance data, Player player) {
        if (player.m_9236_().m_5776_() && !player.m_7578_()) {
            return;
        }
        player.getCapability(KeyPressCapability.INSTANCE).ifPresent(cap -> {
            IActivePower.Key key = (IActivePower.Key)data.get("key");
            if (!cap.getKeysToCheck().contains(key)) {
                cap.addKeyToCheck(key);
                if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ApugliPacketHandler.sendS2C(new AddKeyToCheckPacket(serverPlayer.m_19879_(), key), serverPlayer);
                }
            }
        });
    }

    @Override
    public boolean isCurrentlyUsingKey(SerializableData.Instance data, Player player) {
        Optional capability = player.getCapability(KeyPressCapability.INSTANCE).resolve();
        if (capability.isPresent()) {
            IActivePower.Key key = (IActivePower.Key)data.get("key");
            return ((KeyPressCapability)capability.get()).getCurrentlyUsedKeys().stream().anyMatch(otherKey -> ActiveKeyUtil.equals(key, otherKey));
        }
        return false;
    }

    @Override
    public Tuple<Integer, Integer> getHitsOnTarget(Entity actor, LivingEntity target) {
        LazyOptional cap = target.getCapability(HitsOnTargetCapability.INSTANCE);
        if (cap.resolve().isPresent() && ((HitsOnTargetCapability)cap.resolve().get()).getHits().containsKey(actor.m_19879_())) {
            return ((HitsOnTargetCapability)cap.resolve().get()).getHits().get(actor.m_19879_());
        }
        return new Tuple((Object)0, (Object)0);
    }

    @Override
    public void setHitsOnTarget(Entity actor, Entity target, int initialChange, int initialTimerChange, ResourceOperation operation, ResourceOperation timerOperation) {
        target.getCapability(HitsOnTargetCapability.INSTANCE).resolve().ifPresent(capability -> {
            Tuple<Integer, Integer> valueTimerResetTimePair = capability.getHits().getOrDefault(actor.m_19879_(), (Tuple<Integer, Integer>)new Tuple((Object)0, (Object)0));
            int change = operation == ResourceOperation.SET ? initialChange : (Integer)valueTimerResetTimePair.m_14418_() + initialChange;
            int timerChange = timerOperation == ResourceOperation.SET ? initialTimerChange : (Integer)valueTimerResetTimePair.m_14419_() + initialTimerChange;
            capability.setHits(actor.m_19879_(), change, timerChange);
            if (!(target instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)target;
            ApugliPacketHandler.sendS2CTrackingAndSelf(new SyncHitsOnTargetLessenedPacket(target.m_19879_(), capability.getPreviousHits(), capability.getHits()), (Entity)serverPlayer);
        });
    }

    @Override
    public HudRender getDefaultHudRender() {
        return HudRenderUtil.DONT_RENDER;
    }

    @Override
    public float getEntityEyeHeight(Entity entity) {
        return entity.getEyeHeightAccess(entity.m_20089_(), entity.m_6972_(entity.m_20089_()));
    }

    @Override
    public SerializableDataType<?> damageSourceDescriptionDataType() {
        return ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION;
    }

    @Override
    public DamageSource createDamageSource(DamageSources damageSources, SerializableData.Instance data, String typeFieldName, String descriptionFieldName) {
        return MiscUtil.createDamageSource((DamageSources)damageSources, Optional.ofNullable((DamageSourceDescription)data.get(descriptionFieldName)), Optional.ofNullable((ResourceKey)data.get(typeFieldName)));
    }

    @Override
    public DamageSource createDamageSource(DamageSources damageSources, SerializableData.Instance data, Entity attacker, String typeFieldName, String descriptionFieldName) {
        return MiscUtil.createDamageSource((DamageSources)damageSources, Optional.ofNullable((DamageSourceDescription)data.get(descriptionFieldName)), Optional.ofNullable((ResourceKey)data.get(typeFieldName)), (Entity)attacker);
    }

    @Override
    public DamageSource createDamageSource(DamageSources damageSources, SerializableData.Instance data, Entity source, Entity attacker, String typeFieldName, String descriptionFieldName) {
        return MiscUtil.createDamageSource((DamageSources)damageSources, Optional.ofNullable((DamageSourceDescription)data.get(descriptionFieldName)), Optional.ofNullable((ResourceKey)data.get(typeFieldName)), (Entity)source, (Entity)attacker);
    }

    @Override
    public boolean canSetPose(Player player) {
        return player.getForcedPose() == null;
    }

    @Override
    public void setForcedPlayerPose(Player player, @Nullable Pose pose) {
        player.setForcedPose(pose);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Services.PLATFORM.sendS2CTrackingAndSelf(new ForcePlayerPosePacket(serverPlayer.m_19879_(), pose), (Entity)serverPlayer);
        }
    }
}

