/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.platform;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiomeCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBlockCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredDamageCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredFluidCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredItemCondition;
import io.github.edwinmindcraft.apoli.common.registry.condition.ApoliDefaultConditions;
import java.util.Optional;
import java.util.function.Predicate;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.condition.FabricBiEntityCondition;
import net.merchantpug.apugli.condition.FabricBiomeCondition;
import net.merchantpug.apugli.condition.FabricBlockCondition;
import net.merchantpug.apugli.condition.FabricDamageCondition;
import net.merchantpug.apugli.condition.FabricEntityCondition;
import net.merchantpug.apugli.condition.FabricFluidCondition;
import net.merchantpug.apugli.condition.FabricItemCondition;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.merchantpug.apugli.data.ApoliForgeDataTypes;
import net.merchantpug.apugli.platform.services.IConditionHelper;
import net.merchantpug.apugli.registry.ApugliRegisters;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@AutoService(value={IConditionHelper.class})
public class ForgeConditionHelper
implements IConditionHelper {
    @Override
    public SerializableDataType<?> biEntityDataType() {
        return ApoliForgeDataTypes.BIENTITY_CONDITION;
    }

    @Override
    public void registerBiEntity(String name, IConditionFactory<Tuple<Entity, Entity>> condition) {
        ApugliRegisters.BIENTITY_CONDITIONS.register(name, () -> new FabricBiEntityCondition(condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkBiEntity(SerializableData.Instance data, String fieldName, Entity actor, Entity target) {
        return !data.isPresent(fieldName) || ((ConfiguredBiEntityCondition)data.get(fieldName)).check(actor, target);
    }

    @Override
    public <C> boolean checkBiEntity(C condition, Entity actor, Entity target) {
        return condition == null || ((ConfiguredBiEntityCondition)condition).check(actor, target);
    }

    @Override
    @Nullable
    public Predicate<Tuple<Entity, Entity>> biEntityPredicate(SerializableData.Instance data, String fieldName) {
        if (!data.isPresent(fieldName)) {
            return null;
        }
        return pair -> ((ConfiguredBiEntityCondition)data.get(fieldName)).check((Entity)pair.m_14418_(), (Entity)pair.m_14419_());
    }

    @Override
    public <T> void writeBiEntityConditionToNbt(CompoundTag tag, String path, T object) {
        if (object == null) {
            return;
        }
        Tag actionTag = (Tag)ConfiguredBiEntityCondition.CODEC.encode((Object)((ConfiguredBiEntityCondition)object), (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).resultOrPartial(arg_0 -> ((Logger)Apugli.LOG).error(arg_0)).orElse(new CompoundTag());
        tag.m_128365_(path, actionTag);
    }

    @Override
    public <T> T readBiEntityConditionFromNbt(CompoundTag tag, String path) {
        if (tag.m_128425_(path, 10)) {
            Optional optional = ConfiguredBiEntityCondition.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_(path)).resultOrPartial(arg_0 -> ((Logger)Apugli.LOG).error(arg_0));
            if (optional.isPresent()) {
                return (T)optional.map(Pair::getFirst).get();
            }
        }
        return (T)ApoliDefaultConditions.BIENTITY_DEFAULT.get();
    }

    @Override
    public SerializableDataType<?> biomeDataType() {
        return ApoliForgeDataTypes.BIOME_CONDITION;
    }

    @Override
    public void registerBiome(String name, IConditionFactory<Holder<Biome>> condition) {
        ApugliRegisters.BIOME_CONDITIONS.register(name, () -> new FabricBiomeCondition(condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkBiome(SerializableData.Instance data, String fieldName, Holder<Biome> biome) {
        return !data.isPresent(fieldName) || ((ConfiguredBiomeCondition)data.get(fieldName)).check(biome);
    }

    @Override
    @Nullable
    public Predicate<Holder<Biome>> biomePredicate(SerializableData.Instance data, String fieldName) {
        if (!data.isPresent(fieldName)) {
            return null;
        }
        return biome -> ((ConfiguredBiomeCondition)data.get(fieldName)).check(biome);
    }

    @Override
    public <C> boolean checkBiome(C condition, Holder<Biome> biome) {
        return condition != null && ((ConfiguredBiomeCondition)condition).check(biome);
    }

    @Override
    public SerializableDataType<?> blockDataType() {
        return ApoliForgeDataTypes.BLOCK_CONDITION;
    }

    @Override
    public void registerBlock(String name, IConditionFactory<BlockInWorld> condition) {
        ApugliRegisters.BLOCK_CONDITIONS.register(name, () -> new FabricBlockCondition(condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkBlock(SerializableData.Instance data, String fieldName, Level level, BlockPos pos) {
        return !data.isPresent(fieldName) || ((ConfiguredBlockCondition)data.get(fieldName)).check((LevelReader)level, pos, () -> level.m_8055_(pos));
    }

    @Override
    public <C> boolean checkBlock(C condition, Level level, BlockPos pos) {
        return condition != null && ((ConfiguredBlockCondition)condition).check((LevelReader)level, pos, () -> level.m_8055_(pos));
    }

    @Override
    public <T> void writeBlockConditionToNbt(CompoundTag tag, String path, T object) {
        if (object == null) {
            return;
        }
        Tag actionTag = (Tag)ConfiguredBlockCondition.CODEC.encode((Object)((ConfiguredBlockCondition)object), (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).resultOrPartial(arg_0 -> ((Logger)Apugli.LOG).error(arg_0)).orElse(new CompoundTag());
        tag.m_128365_(path, actionTag);
    }

    @Override
    public <T> T readBlockConditionFromNbt(CompoundTag tag, String path) {
        if (tag.m_128425_(path, 10)) {
            Optional optional = ConfiguredBlockCondition.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_(path)).resultOrPartial(arg_0 -> ((Logger)Apugli.LOG).error(arg_0));
            if (optional.isPresent()) {
                return (T)optional.map(Pair::getFirst).get();
            }
        }
        return (T)ApoliDefaultConditions.BLOCK_DEFAULT.get();
    }

    @Override
    @Nullable
    public Predicate<BlockInWorld> blockPredicate(SerializableData.Instance data, String fieldName) {
        if (!data.isPresent(fieldName)) {
            return null;
        }
        return block -> ((ConfiguredBlockCondition)data.get(fieldName)).check(block.m_61175_(), block.m_61176_(), () -> ((BlockInWorld)block).m_61168_());
    }

    @Override
    public SerializableDataType<?> damageDataType() {
        return ApoliForgeDataTypes.DAMAGE_CONDITION;
    }

    @Override
    public void registerDamage(String name, IConditionFactory<Tuple<DamageSource, Float>> condition) {
        ApugliRegisters.DAMAGE_CONDITIONS.register(name, () -> new FabricDamageCondition(condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkDamage(SerializableData.Instance data, String fieldName, DamageSource source, float amount) {
        return !data.isPresent(fieldName) || ((ConfiguredDamageCondition)data.get(fieldName)).check(source, amount);
    }

    @Override
    public <C> boolean checkDamage(C condition, DamageSource source, float amount) {
        return condition != null && ((ConfiguredDamageCondition)condition).check(source, amount);
    }

    @Override
    @Nullable
    public Predicate<Tuple<DamageSource, Float>> damagePredicate(SerializableData.Instance data, String fieldName) {
        if (!data.isPresent(fieldName)) {
            return null;
        }
        return pair -> ((ConfiguredDamageCondition)data.get(fieldName)).check((DamageSource)pair.m_14418_(), ((Float)pair.m_14419_()).floatValue());
    }

    @Override
    public SerializableDataType<?> entityDataType() {
        return ApoliForgeDataTypes.ENTITY_CONDITION;
    }

    @Override
    public void registerEntity(String name, IConditionFactory<Entity> condition) {
        ApugliRegisters.ENTITY_CONDITIONS.register(name, () -> new FabricEntityCondition(condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkEntity(SerializableData.Instance data, String fieldName, Entity entity) {
        return !data.isPresent(fieldName) || ((ConfiguredEntityCondition)data.get(fieldName)).check(entity);
    }

    @Override
    public <C> boolean checkEntity(C condition, Entity entity) {
        return condition != null && ((ConfiguredEntityCondition)condition).check(entity);
    }

    @Override
    @Nullable
    public Predicate<Entity> entityPredicate(SerializableData.Instance data, String fieldName) {
        if (!data.isPresent(fieldName)) {
            return null;
        }
        return entity -> ((ConfiguredEntityCondition)data.get(fieldName)).check(entity);
    }

    @Override
    public SerializableDataType<?> fluidDataType() {
        return ApoliForgeDataTypes.FLUID_CONDITION;
    }

    @Override
    public void registerFluid(String name, IConditionFactory<FluidState> condition) {
        ApugliRegisters.FLUID_CONDITIONS.register(name, () -> new FabricFluidCondition(condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkFluid(SerializableData.Instance data, String fieldName, FluidState fluidState) {
        return !data.isPresent(fieldName) || ((ConfiguredFluidCondition)data.get(fieldName)).check(fluidState);
    }

    @Override
    public <C> boolean checkFluid(C condition, FluidState fluidState) {
        return false;
    }

    @Override
    @Nullable
    public Predicate<FluidState> fluidPredicate(SerializableData.Instance data, String fieldName) {
        if (!data.isPresent(fieldName)) {
            return null;
        }
        return fluid -> ((ConfiguredFluidCondition)data.get(fieldName)).check(fluid);
    }

    @Override
    public SerializableDataType<?> itemDataType() {
        return ApoliForgeDataTypes.ITEM_CONDITION;
    }

    @Override
    public void registerItem(String name, IConditionFactory<ItemStack> condition) {
        ApugliRegisters.ITEM_CONDITIONS.register(name, () -> new FabricItemCondition(condition.getSerializableData(), condition::check));
    }

    @Override
    public boolean checkItem(SerializableData.Instance data, String fieldName, Level level, ItemStack stack) {
        return !data.isPresent(fieldName) || ((ConfiguredItemCondition)data.get(fieldName)).check(level, stack);
    }

    @Override
    public <C> boolean checkItem(C condition, Level level, ItemStack stack) {
        return condition != null && ((ConfiguredItemCondition)condition).check(level, stack);
    }

    @Override
    @Nullable
    public Predicate<Tuple<Level, ItemStack>> itemPredicate(SerializableData.Instance data, String fieldName) {
        if (!data.isPresent(fieldName)) {
            return null;
        }
        return levelAndStack -> ((ConfiguredItemCondition)data.get(fieldName)).check((Level)levelAndStack.m_14418_(), (ItemStack)levelAndStack.m_14419_());
    }
}

