/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import java.util.HashMap;
import java.util.Map;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.capability.entity.HitsOnTargetCapability;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record SyncHitsOnTargetCapabilityPacket(int entityId, Map<Integer, Tuple<Integer, Integer>> hits) implements ApugliPacketS2C
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.hits.size());
        this.hits.forEach((entityId, value) -> {
            buf.writeInt(entityId.intValue());
            buf.writeInt(((Integer)value.m_14418_()).intValue());
            buf.writeInt(((Integer)value.m_14419_()).intValue());
        });
    }

    public static SyncHitsOnTargetCapabilityPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int hitsSize = buf.readInt();
        HashMap<Integer, Tuple<Integer, Integer>> hits = new HashMap<Integer, Tuple<Integer, Integer>>();
        for (int i = 0; i < hitsSize; ++i) {
            int otherEntityId = buf.readInt();
            int amount = buf.readInt();
            int ticksLeft = buf.readInt();
            hits.put(otherEntityId, (Tuple<Integer, Integer>)new Tuple((Object)amount, (Object)ticksLeft));
        }
        return new SyncHitsOnTargetCapabilityPacket(entityId, hits);
    }

    @Override
    public ResourceLocation getFabricId() {
        throw new RuntimeException("ApugliPacket#getFabricId is not meant to be used in Forge specific packets.");
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(SyncHitsOnTargetCapabilityPacket.this.entityId);
                if (!(entity instanceof LivingEntity)) {
                    Apugli.LOG.warn("Could not find living entity to sync hits on target with.");
                    return;
                }
                entity.getCapability(HitsOnTargetCapability.INSTANCE).ifPresent(capability -> {
                    capability.getHits().clear();
                    SyncHitsOnTargetCapabilityPacket.this.hits.forEach((id, value) -> capability.setHits((int)id, (Integer)value.m_14418_(), (Integer)value.m_14419_()));
                });
            }
        });
    }
}

