/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public record ForcePlayerPosePacket(int entityId, Pose pose) implements ApugliPacketS2C
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        buf.writeBoolean(this.pose() != null);
        if (this.pose() != null) {
            buf.m_130068_((Enum)this.pose());
        }
    }

    public static ForcePlayerPosePacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        Pose pose = null;
        if (buf.readBoolean()) {
            pose = (Pose)buf.m_130066_(Pose.class);
        }
        return new ForcePlayerPosePacket(entityId, pose);
    }

    @Override
    public ResourceLocation getFabricId() {
        throw new RuntimeException("ApugliPacket#getFabricId is not meant to be used in Forge specific packets.");
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(ForcePlayerPosePacket.this.entityId());
                if (!(entity instanceof Player)) {
                    Apugli.LOG.warn("Could not find player entity to sync keys with.");
                    return;
                }
                Player player = (Player)entity;
                player.setForcedPose(ForcePlayerPosePacket.this.pose());
            }
        });
    }
}

