/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.integration.pehkui;

import com.google.common.collect.ImmutableSet;
import io.github.apace100.calio.data.SerializableData;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.access.ScaleDataAccess;
import net.merchantpug.apugli.integration.pehkui.ApoliScaleModifier;
import net.merchantpug.apugli.integration.pehkui.DelayedApoliScaleModifier;
import net.merchantpug.apugli.network.s2c.integration.pehkui.SyncScalePacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class PehkuiUtil {
    private static final Map<UUID, SortedSet<ApoliScaleModifier<?>>> MODIFIERS_IN_ORDER = new HashMap();

    private static void createModifiersInOrder(LivingEntity entity, ApoliScaleModifier<?> modifier, boolean remove) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!MODIFIERS_IN_ORDER.containsKey(entity.m_20148_())) {
            MODIFIERS_IN_ORDER.put(entity.m_20148_(), (SortedSet<ApoliScaleModifier<?>>)new ObjectAVLTreeSet());
        }
        if (!remove) {
            MODIFIERS_IN_ORDER.get(entity.m_20148_()).add(modifier);
        } else {
            MODIFIERS_IN_ORDER.get(entity.m_20148_()).remove(modifier);
            if (MODIFIERS_IN_ORDER.get(entity.m_20148_()).isEmpty()) {
                MODIFIERS_IN_ORDER.remove(entity.m_20148_());
            }
        }
    }

    public static SortedSet<ApoliScaleModifier<?>> getModifiersInOrder(LivingEntity entity) {
        if (!MODIFIERS_IN_ORDER.containsKey(entity.m_20148_())) {
            return new ObjectAVLTreeSet();
        }
        return MODIFIERS_IN_ORDER.get(entity.m_20148_());
    }

    public static Set<ResourceLocation> getTypesFromCache(SerializableData.Instance data) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        data.ifPresent("scale_type", id -> {
            if (PehkuiUtil.validate(id)) {
                builder.add(id);
            }
        });
        data.ifPresent("scale_types", ids -> ids.forEach(id -> {
            if (PehkuiUtil.validate(id)) {
                builder.add(id);
            }
        }));
        return builder.build();
    }

    private static boolean validate(ResourceLocation typeId) {
        boolean value = ScaleRegistries.SCALE_TYPES.containsKey((Object)typeId);
        if (!value) {
            Apugli.LOG.error("Identifier '{}' is not a valid scale type.", (Object)typeId);
        }
        return value;
    }

    public static ScaleType getScaleType(ResourceLocation id) {
        return (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)id);
    }

    public static void tickScalePowers(LivingEntity entity) {
        if (!MODIFIERS_IN_ORDER.containsKey(entity.m_20148_()) || MODIFIERS_IN_ORDER.get(entity.m_20148_()).isEmpty() || MODIFIERS_IN_ORDER.get(entity.m_20148_()).size() != Services.POWER.getPowers(entity, ApugliPowers.MODIFY_SCALE.get(), true).size()) {
            return;
        }
        for (ApoliScaleModifier apoliScaleModifier : MODIFIERS_IN_ORDER.get(entity.m_20148_())) {
            if (!entity.m_9236_().m_5776_()) {
                apoliScaleModifier.addScales(entity);
                apoliScaleModifier.tick(entity);
            }
            apoliScaleModifier.updateIfShould(entity);
        }
    }

    public static <P> void onAddedOrRespawnedScalePower(P power, LivingEntity entity) {
        Object object = ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(power, (Entity)entity);
        if (!(object instanceof ApoliScaleModifier)) {
            return;
        }
        ApoliScaleModifier scaleModifier = (ApoliScaleModifier)((Object)object);
        if (entity != null) {
            PehkuiUtil.createModifiersInOrder(entity, scaleModifier, false);
            scaleModifier.updateOthers(entity);
        }
    }

    public static <P> Object createApoliScaleModifier(P power, LivingEntity entity, SerializableData.Instance data) {
        if (!data.isPresent("modifier") && !data.isPresent("modifiers")) {
            Apugli.LOG.error("Could not create scale power modifier as the 'modifier' and 'modifiers' fields are both not specified.");
            return new ApoliScaleModifier<P>(power, entity, List.of(), Set.of(), 0);
        }
        ApoliScaleModifier modifier = data.getInt("delay") > 0 ? new DelayedApoliScaleModifier<P>(power, entity, ApugliPowers.MODIFY_SCALE.get().getModifiers(power, (Entity)entity), ApugliPowers.MODIFY_SCALE.get().getDelayModifiers(power, (Entity)entity), data.getInt("delay"), PehkuiUtil.getTypesFromCache(data), data.getInt("priority"), Optional.ofNullable((ResourceLocation)data.get("easing"))) : new ApoliScaleModifier(power, entity, ApugliPowers.MODIFY_SCALE.get().getModifiers(power, (Entity)entity), PehkuiUtil.getTypesFromCache(data), data.getInt("priority"));
        return modifier;
    }

    public static <P> void onRemovedScalePower(P power, LivingEntity entity) {
        ApoliScaleModifier modifier = (ApoliScaleModifier)((Object)ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(power, (Entity)entity));
        PehkuiUtil.removeModifierFromOrderList(entity, modifier);
        for (ResourceLocation scaleTypeId : modifier.getCachedScaleIds()) {
            ScaleType scaleType = PehkuiUtil.getScaleType(scaleTypeId);
            ScaleData scaleData = scaleType.getScaleData((Entity)entity);
            modifier.updateOthers(entity);
            ((ScaleDataAccess)scaleData).apugli$removeFromApoliScaleModifiers(ApugliPowers.MODIFY_SCALE.get().getPowerId(power));
            scaleData.getBaseValueModifiers().remove((Object)modifier);
            scaleData.onUpdate();
        }
        Services.PLATFORM.sendS2CTrackingAndSelf(SyncScalePacket.removeScaleFromClient(entity.m_19879_(), modifier.getCachedScaleIds().stream().toList(), ApugliPowers.MODIFY_SCALE.get().getPowerId(power)), (Entity)entity);
    }

    public static void resetScalePower(Object modifier) {
        if (!(modifier instanceof ApoliScaleModifier)) {
            return;
        }
        ApoliScaleModifier apoliScaleModifier = (ApoliScaleModifier)((Object)modifier);
        apoliScaleModifier.reset();
    }

    public static void removeModifierFromOrderList(LivingEntity entity, ApoliScaleModifier<?> modifier) {
        PehkuiUtil.createModifiersInOrder(entity, modifier, true);
    }

    public static <P> CompoundTag serializeScalePower(P power, LivingEntity entity, CompoundTag tag) {
        ApoliScaleModifier modifier = (ApoliScaleModifier)((Object)ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(power, (Entity)entity));
        return modifier.serialize(tag);
    }

    public static <P> void deserializeScalePower(P power, LivingEntity entity, CompoundTag tag) {
        ApoliScaleModifier modifier = (ApoliScaleModifier)((Object)ApugliPowers.MODIFY_SCALE.get().getApoliScaleModifier(power, (Entity)entity));
        modifier.deserialize(tag, entity);
    }

    public static float getScale(Entity entity, ResourceLocation scaleTypeId) {
        return ((ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)scaleTypeId)).getScaleData(entity).getScale();
    }
}

