/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.condition.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class BaseEnchantmentCondition
implements IConditionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT).add("compare_to", SerializableDataTypes.INT).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL).add("calculation", SerializableDataType.enumValue(CalculationType.class), (Object)CalculationType.SUM);
    }

    @Override
    public boolean check(SerializableData.Instance data, Entity entity) {
        int value = 0;
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            Enchantment enchantment = (Enchantment)data.get("enchantment");
            CalculationType calculation = (CalculationType)((Object)data.get("calculation"));
            switch (calculation) {
                case SUM: {
                    for (ItemStack stack : enchantment.m_44684_(le).values()) {
                        value += EnchantmentHelper.m_44882_((ListTag)stack.m_41785_()).getOrDefault(enchantment, 0).intValue();
                    }
                    break;
                }
                case TOTAL: {
                    for (ItemStack stack : enchantment.m_44684_(le).values()) {
                        int potentialValue = EnchantmentHelper.m_44882_((ListTag)stack.m_41785_()).getOrDefault(enchantment, 0);
                        if (potentialValue <= value) continue;
                        value = potentialValue;
                    }
                    break;
                }
            }
        }
        Comparison comparison = (Comparison)data.get("comparison");
        return comparison.compare((double)value, (double)data.getInt("compare_to"));
    }

    public static enum CalculationType {
        SUM,
        TOTAL;

    }
}

