/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FireProjectileAction
implements IActionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("count", SerializableDataTypes.INT, (Object)1).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("divergence", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("entity_type", SerializableDataTypes.ENTITY_TYPE).add("tag", SerializableDataTypes.NBT, null).add("bientity_action", Services.ACTION.biEntityDataType(), null);
    }

    @Override
    public void execute(SerializableData.Instance data, Entity entity) {
        if (data.isPresent("sound")) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)data.get("sound"), SoundSource.NEUTRAL, 0.5f, 0.4f / (((LivingEntity)entity).m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        EntityType type = (EntityType)data.get("entity_type");
        float speed = data.getFloat("speed");
        float divergence = data.getFloat("divergence") * 0.075f;
        CompoundTag tag = (CompoundTag)data.get("tag");
        for (int i = 0; i < data.getInt("count"); ++i) {
            Entity result = this.createProjectile((LivingEntity)entity, type, speed, divergence, tag);
            if (result == null) continue;
            entity.m_9236_().m_7967_(result);
            Services.ACTION.executeBiEntity(data, "bientity_action", entity, result);
        }
    }

    @Nullable
    protected Entity createProjectile(LivingEntity actor, EntityType<?> type, float speed, float divergence, @Nullable CompoundTag tag) {
        Entity result = type.m_20615_(actor.m_9236_());
        if (result == null) {
            return null;
        }
        Vec3 rotationVec = actor.m_20154_();
        Vec3 spawnPos = actor.m_20182_().m_82520_(0.0, (double)actor.m_20192_(), 0.0).m_82549_(rotationVec);
        result.m_7678_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), actor.m_146909_(), actor.m_146908_());
        if (result instanceof Projectile) {
            Projectile projectile = (Projectile)result;
            if (result instanceof AbstractHurtingProjectile) {
                AbstractHurtingProjectile abstractHurtingProjectile = (AbstractHurtingProjectile)result;
                abstractHurtingProjectile.f_36813_ = rotationVec.f_82479_ * (double)speed;
                abstractHurtingProjectile.f_36814_ = rotationVec.f_82480_ * (double)speed;
                abstractHurtingProjectile.f_36815_ = rotationVec.f_82481_ * (double)speed;
            }
            projectile.m_5602_((Entity)actor);
            projectile.m_37251_((Entity)actor, actor.m_146909_(), actor.m_146908_(), 0.0f, speed, divergence);
        } else {
            float f = -Mth.m_14031_((float)(actor.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(actor.m_146909_() * ((float)Math.PI / 180)));
            float g = -Mth.m_14031_((float)(actor.m_146909_() * ((float)Math.PI / 180)));
            float h = Mth.m_14089_((float)(actor.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(actor.m_146909_() * ((float)Math.PI / 180)));
            Vec3 divergenceVec = new Vec3((double)f, (double)g, (double)h).m_82541_().m_82520_(actor.m_217043_().m_188583_() * (double)divergence, actor.m_217043_().m_188583_() * (double)divergence, actor.m_217043_().m_188583_() * (double)divergence).m_82490_((double)speed);
            result.m_20256_(divergenceVec);
            Vec3 entityVec = actor.m_20184_();
            if (actor.m_20096_()) {
                entityVec = entityVec.m_82542_(1.0, 0.0, 1.0);
            }
            result.m_20256_(result.m_20184_().m_82549_(entityVec));
        }
        if (tag != null) {
            CompoundTag mergedTag = result.m_20240_(new CompoundTag());
            mergedTag.m_128391_(tag);
            result.m_20258_(mergedTag);
        }
        return result;
    }
}

