/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.merchantpug.apugli.access.ExplosionAccess;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.network.s2c.SyncExplosionPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.ApugliTags;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExplodeAction
implements IActionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("power", SerializableDataTypes.FLOAT).add("destruction_type", ApoliDataTypes.BACKWARDS_COMPATIBLE_DESTRUCTION_TYPE, (Object)Explosion.BlockInteraction.DESTROY).add("damage_self", SerializableDataTypes.BOOLEAN, (Object)true).add("indestructible", Services.CONDITION.blockDataType(), null).add("destructible", Services.CONDITION.blockDataType(), null).add("create_fire", SerializableDataTypes.BOOLEAN, (Object)false).add("damage_modifier", Services.PLATFORM.getModifierDataType(), null).add("damage_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("knockback_modifier", Services.PLATFORM.getModifierDataType(), null).add("knockback_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("volume_modifier", Services.PLATFORM.getModifierDataType(), null).add("volume_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("pitch_modifier", Services.PLATFORM.getModifierDataType(), null).add("pitch_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("damage_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("use_charged", SerializableDataTypes.BOOLEAN, (Object)false).add("charged_modifier", Services.PLATFORM.getModifierDataType(), null).add("charged_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("spawn_effect_cloud", SerializableDataTypes.BOOLEAN, (Object)false);
    }

    @Override
    public void execute(SerializableData.Instance data, Entity entity) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        float power = data.getFloat("power");
        if (data.getBoolean("use_charged")) {
            power = this.applyChargedModifiers(data, entity, power);
        }
        this.summonExplosion(data, entity, power);
        this.spawnEffectCloud(data, entity);
    }

    protected float applyChargedModifiers(SerializableData.Instance data, Entity entity, float power) {
        if (!(entity instanceof LivingEntity)) {
            return power;
        }
        LivingEntity living = (LivingEntity)entity;
        ArrayList<Object> chargedModifiers = new ArrayList<Object>();
        if (data.isPresent("charged_modifier")) {
            chargedModifiers.add(data.get("charged_modifier"));
        }
        if (data.isPresent("charged_modifiers")) {
            chargedModifiers.addAll((Collection)data.get("charged_modifiers"));
        }
        if (chargedModifiers.isEmpty()) {
            return power;
        }
        if (((LivingEntity)entity).m_21220_().stream().anyMatch(statusEffectInstance -> BuiltInRegistries.f_256974_.m_7854_((Object)statusEffectInstance.m_19544_()).isPresent() && BuiltInRegistries.f_256974_.m_203636_((ResourceKey)BuiltInRegistries.f_256974_.m_7854_((Object)statusEffectInstance.m_19544_()).get()).isPresent() && ((Holder.Reference)BuiltInRegistries.f_256974_.m_203636_((ResourceKey)BuiltInRegistries.f_256974_.m_7854_((Object)statusEffectInstance.m_19544_()).get()).get()).m_203656_(ApugliTags.CHARGED_EFFECTS))) {
            return (float)Services.PLATFORM.applyModifiers((Entity)living, chargedModifiers, (double)data.getFloat("power"));
        }
        return power;
    }

    protected void summonExplosion(SerializableData.Instance data, Entity entity, float power) {
        boolean damageSelf = data.getBoolean("damage_self");
        boolean createFire = data.getBoolean("create_fire");
        Explosion.BlockInteraction destructionType = (Explosion.BlockInteraction)data.get("destruction_type");
        ExplosionDamageCalculator calculator = null;
        boolean indestructible = false;
        String blockConditionFieldKey = null;
        if (data.isPresent("destructible")) {
            calculator = this.createBlockConditionedExplosionDamageCalculator(data, "indestructible", entity.m_9236_(), false);
            blockConditionFieldKey = "destructible";
        } else if (data.isPresent("indestructible")) {
            calculator = this.createBlockConditionedExplosionDamageCalculator(data, "destructible", entity.m_9236_(), true);
            indestructible = true;
            blockConditionFieldKey = "indestructible";
        }
        if (calculator != null) {
            Explosion explosion = new Explosion(entity.m_9236_(), damageSelf ? null : entity, null, calculator, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), power, createFire, destructionType);
            ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.getModifiers(data, "damage_modifier", "damage_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.getModifiers(data, "knockback_modifier", "knockback_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.getModifiers(data, "volume_modifier", "volume_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.getModifiers(data, "pitch_modifier", "pitch_modifiers"));
            ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("damage_bientity_condition"));
            explosion.m_46061_();
            explosion.m_46075_(false);
            Services.PLATFORM.sendS2CTrackingAndSelf(new SyncExplosionPacket<Object, Object>(entity.m_19879_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.getModifiers(data, "damage_modifier", "damage_modifiers"), this.getModifiers(data, "knockback_modifier", "knockback_modifiers"), this.getModifiers(data, "volume_modifier", "volume_modifiers"), this.getModifiers(data, "pitch_modifier", "pitch_modifiers"), data.get("damage_bientity_condition"), true, data.get(blockConditionFieldKey), indestructible, power), entity);
        } else {
            Explosion explosion = new Explosion(entity.m_9236_(), entity, null, null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), power, createFire, destructionType);
            ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.getModifiers(data, "damage_modifier", "damage_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.getModifiers(data, "knockback_modifier", "knockback_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.getModifiers(data, "volume_modifier", "volume_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.getModifiers(data, "pitch_modifier", "pitch_modifiers"));
            ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("damage_bientity_condition"));
            explosion.m_46061_();
            explosion.m_46075_(false);
            Services.PLATFORM.sendS2CTrackingAndSelf(new SyncExplosionPacket<Object, Object>(entity.m_19879_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.getModifiers(data, "damage_modifier", "damage_modifiers"), this.getModifiers(data, "knockback_modifier", "knockback_modifiers"), this.getModifiers(data, "volume_modifier", "volume_modifiers"), this.getModifiers(data, "pitch_modifier", "pitch_modifiers"), data.get("damage_bientity_condition"), false, null, false, power), entity);
        }
    }

    private <M> List<M> getModifiers(SerializableData.Instance data, String modifierKey, String modifiersKey) {
        ArrayList modifiers = new ArrayList();
        data.ifPresent(modifiersKey, modifiers::addAll);
        data.ifPresent(modifierKey, modifiers::add);
        return modifiers;
    }

    private ExplosionDamageCalculator createBlockConditionedExplosionDamageCalculator(final SerializableData.Instance data, final String fieldName, final Level levelIn, final boolean indestructible) {
        return new ExplosionDamageCalculator(){

            public Optional<Float> m_6617_(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState) {
                Optional ovr;
                Optional def = super.m_6617_(explosion, level, pos, blockState, fluidState);
                Optional<Object> optional = ovr = Services.CONDITION.checkBlock(data, fieldName, levelIn, pos) == indestructible ? Optional.of(Float.valueOf(Blocks.f_49990_.m_7325_())) : Optional.empty();
                return ovr.isPresent() ? (def.isPresent() ? (((Float)def.get()).floatValue() > ((Float)ovr.get()).floatValue() ? def : ovr) : ovr) : def;
            }
        };
    }

    protected void spawnEffectCloud(SerializableData.Instance data, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        Collection collection = ((LivingEntity)entity).m_21220_();
        if (!collection.isEmpty() && data.getBoolean("spawn_effect_cloud")) {
            AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            areaEffectCloudEntity.m_19712_(2.5f);
            areaEffectCloudEntity.m_19732_(-0.5f);
            areaEffectCloudEntity.m_19740_(10);
            areaEffectCloudEntity.m_19734_(areaEffectCloudEntity.m_19748_() / 2);
            areaEffectCloudEntity.m_19738_(-areaEffectCloudEntity.m_19743_() / (float)areaEffectCloudEntity.m_19748_());
            for (MobEffectInstance statusEffectInstance : collection) {
                areaEffectCloudEntity.m_19716_(new MobEffectInstance(statusEffectInstance));
            }
            entity.m_9236_().m_7967_((Entity)areaEffectCloudEntity);
        }
    }
}

