/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import com.google.common.hash.Hashing;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.nio.charset.StandardCharsets;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.entity.CustomProjectile;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CustomProjectileAction
implements IActionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("entity_id", SerializableDataTypes.IDENTIFIER).add("texture_location", SerializableDataTypes.IDENTIFIER, null).add("texture_url", SerializableDataTypes.STRING, null).add("count", SerializableDataTypes.INT, (Object)1).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("divergence", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("tag", SerializableDataTypes.NBT, null).add("entity_action_before_firing", Services.ACTION.entityDataType(), null).add("bientity_action_after_firing", Services.ACTION.biEntityDataType(), null).add("block_action_on_hit", Services.ACTION.blockDataType(), null).add("bientity_action_on_miss", Services.ACTION.biEntityDataType(), null).add("bientity_action_on_hit", Services.ACTION.biEntityDataType(), null).add("owner_target_bientity_action_on_hit", Services.ACTION.biEntityDataType(), null).add("block_action_cancels_miss_action", SerializableDataTypes.BOOLEAN, (Object)false).add("block_condition", Services.CONDITION.blockDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("owner_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("tick_bientity_action", Services.ACTION.biEntityDataType(), null);
    }

    @Override
    public void execute(SerializableData.Instance data, Entity entity) {
        if (data.isPresent("sound")) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)data.get("sound"), SoundSource.NEUTRAL, 0.5f, 0.4f / (((LivingEntity)entity).m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        for (int i = 0; i < data.getInt("count"); ++i) {
            Entity result = this.createProjectile(data, (LivingEntity)entity);
            if (result == null) continue;
            entity.m_9236_().m_7967_(result);
            Services.ACTION.executeBiEntity(data, "bientity_action_after_firing", entity, result);
        }
    }

    @Nullable
    protected Entity createProjectile(SerializableData.Instance data, LivingEntity actor) {
        Services.ACTION.executeEntity(data, "entity_action_before_firing", (Entity)actor);
        float yaw = actor.m_146908_();
        float pitch = actor.m_146909_();
        Vec3 rotationVec = actor.m_20154_();
        Vec3 spawnPos = actor.m_20182_().m_82520_(0.0, (double)actor.m_20192_(), 0.0).m_82549_(rotationVec);
        CustomProjectile projectile = new CustomProjectile(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_(), actor, actor.m_9236_());
        projectile.setEntityId(data.getId("entity_id"));
        projectile.m_5602_((Entity)actor);
        projectile.m_37251_((Entity)actor, pitch, yaw, 0.0f, data.getFloat("speed"), data.getFloat("divergence") * 0.075f);
        projectile.setImpactBlockAction(data, "block_action_on_hit");
        projectile.setBlockActionCancelsMissAction(data.getBoolean("block_action_cancels_miss_action"));
        projectile.setMissBiEntityAction(data, "bientity_action_on_miss");
        projectile.setImpactBiEntityAction(data, "bientity_action_on_hit");
        projectile.setOwnerImpactBiEntityAction(data, "owner_target_bientity_action_on_hit");
        projectile.setTextureLocation(data.getId("texture_location"));
        projectile.setBlockCondition(data, "block_condition");
        projectile.setOwnerBiEntityCondition(data, "owner_bientity_condition");
        projectile.setBiEntityCondition(data, "bientity_condition");
        projectile.setTickBiEntityAction(data, "tick_bientity_action");
        if (data.isPresent("texture_url")) {
            projectile.setUrlLocation(CustomProjectileAction.getTextureUrl(data.getString("texture_url")));
        }
        if (data.get("tag") != null) {
            CompoundTag mergedTag = projectile.m_20240_(new CompoundTag());
            mergedTag.m_128391_((CompoundTag)data.get("tag"));
            projectile.m_20258_(mergedTag);
        }
        return projectile;
    }

    public static ResourceLocation getTextureUrl(String textureUrl) {
        int sha256Hash = Hashing.sha256().hashString((CharSequence)textureUrl, StandardCharsets.UTF_8).asInt();
        return new ResourceLocation("apugli", "customprojectileaction/" + sha256Hash);
    }
}

