/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.AcropolisMonsters;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.AI.InternalAttackGoal;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.Internal_Animation_Monster;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.etc.path.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.etc.path.SemiAquaticPathNavigator;
import com.github.L_Ender.cataclysm.entity.projectile.Water_Spear_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.init.ModTag;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Cindaria_Entity
extends Internal_Animation_Monster {
    boolean searchingForLand;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState magic1AnimationState = new AnimationState();
    public AnimationState meleeAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    private int magic_cooldown = 0;
    public static final int CHARGE_COOLDOWN = 100;
    protected final SemiAquaticPathNavigator waterNavigation;
    protected final CMPathNavigateGround groundNavigation;

    public Cindaria_Entity(EntityType entity, Level world) {
        super(entity, world);
        this.f_21364_ = 25;
        this.m_274367_(1.75f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.waterNavigation = new SemiAquaticPathNavigator((Mob)this, world);
        this.groundNavigation = new CMPathNavigateGround((Mob)this, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(3, (Goal)new CindariaMoveGoal(this, 1.0, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new InternalAttackGoal(this, 0, 2, 0, 39, 13, 3.75f));
        this.f_21345_.m_25352_(2, (Goal)new MagicAttackGoal(this, 0, 1, 0, 50, 15, 4.5f, 16.0f));
    }

    public static AttributeSupplier.Builder cindaria() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22276_, 60.0);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6109_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.f_21342_ = new CindariaSwimControl(this, 4.0f);
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.f_21342_ = new MoveControl((Mob)this);
                this.m_20282_(false);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Entity entity = source.m_7640_();
        return super.m_6469_(source, damage);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public AnimationState getAnimationState(String input) {
        if (input == "magic1") {
            return this.magic1AnimationState;
        }
        if (input == "melee") {
            return this.meleeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        return new AnimationState();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_)) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.magic1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.meleeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.magic1AnimationState.m_216973_();
        this.meleeAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.setAttackState(3);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.CINDARIA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CINDARIA_DEATH.get();
    }

    @Override
    public int deathtimer() {
        return 40;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(true, this.f_19797_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() == 2 && this.attackTicks == 14) {
            this.AreaAttack(4.75f, 4.75f, 100.0f, 1.0f, 0, true);
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean knockback) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        if (!this.m_9236_().f_46443_) {
            for (LivingEntity entityHit : entitiesHit) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Cindaria_Entity || entityHit == this) continue;
                DamageSource damagesource = this.m_269291_().m_269333_((LivingEntity)this);
                boolean hurt = entityHit.m_6469_(damagesource, (float)(this.m_21133_(Attributes.f_22281_) * (double)damage));
                if (entityHit.m_21275_(damagesource) && entityHit instanceof Player) {
                    Player player = (Player)entityHit;
                    if (shieldbreakticks > 0) {
                        this.disableShield(player, shieldbreakticks);
                    }
                }
                double d0 = entityHit.m_20185_() - this.m_20185_();
                double d1 = entityHit.m_20189_() - this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                if (!hurt || !knockback) continue;
                entityHit.m_5997_(d0 / d2 * 2.25, 0.15, d1 / d2 * 2.25);
            }
        }
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn.m_6095_().m_204039_(ModTag.TEAM_SCYLLA)) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() != ModEffect.EFFECTABYSSAL_CURSE.get() && super.m_7301_(p_34192_);
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    protected boolean m_7341_(Entity p_31508_) {
        return false;
    }

    public static class CindariaMoveGoal
    extends Goal {
        private final Cindaria_Entity mob;
        private final double speedModifier;
        private final float attackRadiusSqr;
        private int seeTime;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public CindariaMoveGoal(Cindaria_Entity p_25792_, double p_25793_, float p_25795_) {
            this.mob = p_25792_;
            this.speedModifier = p_25793_;
            this.attackRadiusSqr = p_25795_ * p_25795_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
            this.seeTime = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                    this.mob.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.8f : 0.8f, 0.0f);
                    Entity entity = this.mob.m_275832_();
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                    }
                    this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
            }
        }
    }

    static class MagicAttackGoal
    extends Goal {
        protected final Cindaria_Entity entity;
        private final int getAttackState;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackminrange;
        private final float attackrange;

        public MagicAttackGoal(Cindaria_Entity entity, int getAttackState, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackminrange, float attackrange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getAttackState = getAttackState;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackminrange = attackminrange;
            this.attackrange = attackrange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && this.entity.m_20270_((Entity)target) > this.attackminrange && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getAttackState && this.entity.magic_cooldown <= 0;
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
        }

        public boolean m_8045_() {
            return this.entity.attackTicks < this.attackMaxtick;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            if (this.entity.attackTicks == this.attackseetick && target != null) {
                double d0 = this.entity.m_20185_();
                double d1 = this.entity.m_20186_() + (double)(this.entity.m_20206_() * 0.5f);
                double d2 = this.entity.m_20189_();
                double d3 = target.m_20185_() - d0;
                double d4 = target.m_20186_() - d1;
                double d5 = target.m_20189_() - d2;
                Vec3 vec3 = new Vec3(d3, d4, d5).m_82541_();
                Water_Spear_Entity waterSpear = new Water_Spear_Entity((LivingEntity)this.entity, vec3, this.entity.m_9236_(), (float)CMConfig.HarbingerWitherMissiledamage);
                float yRot = (float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.29577951308232) + 90.0f;
                float xRot = (float)(-(Mth.m_14136_((double)vec3.f_82480_, (double)Math.sqrt(vec3.f_82479_ * vec3.f_82479_ + vec3.f_82481_ * vec3.f_82481_)) * 57.29577951308232));
                waterSpear.m_146922_(yRot);
                waterSpear.m_146926_(xRot);
                waterSpear.m_20343_(d0, d1, d2);
                waterSpear.setTotalBounces(10);
                this.entity.m_9236_().m_7967_((Entity)waterSpear);
            }
        }
    }

    static class CindariaSwimControl
    extends MoveControl {
        private final Cindaria_Entity drowned;
        private final float speedMulti;

        public CindariaSwimControl(Cindaria_Entity p_32433_, float speedMulti) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
            this.speedMulti = speedMulti;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * (double)this.speedMulti * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

