/*
 * Decompiled with CFR 0.152.
 */
package dev.bsmp.emotetweaks.emotetweaks.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.bsmp.emotetweaks.emotetweaks.EmoteTweaksMain;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.config.ClientConfigSerializer;
import java.util.Map;
import java.util.UUID;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientConfigSerializer.class}, remap=false)
public abstract class ClientConfigSerializerMixin {
    @Inject(method={"clientDeserialize"}, at={@At(value="TAIL")})
    private void deserializeCrouchCancels(JsonObject node, SerializableConfig sconfig, CallbackInfo ci) {
        if (node.has("crouchCancel")) {
            this.crouchCancelDeserializer(node.get("crouchCancel"));
        }
    }

    private void crouchCancelDeserializer(JsonElement node) {
        for (Map.Entry element : node.getAsJsonObject().entrySet()) {
            EmoteTweaksMain.CROUCH_CANCEL_MAP.put((Object)UUID.fromString((String)element.getKey()), ((JsonElement)element.getValue()).getAsBoolean());
        }
    }

    @Inject(method={"clientSerialize"}, at={@At(value="TAIL")})
    private void serializeCrouchCancels(ClientConfig config, JsonObject node, CallbackInfo ci) {
        node.add("crouchCancel", this.crouchCancelSerializer());
    }

    private JsonElement crouchCancelSerializer() {
        JsonObject array = new JsonObject();
        for (Map.Entry entry : EmoteTweaksMain.CROUCH_CANCEL_MAP.object2BooleanEntrySet()) {
            array.addProperty(((UUID)entry.getKey()).toString(), (Boolean)entry.getValue());
        }
        return array;
    }
}

