/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.gui.BiomeInfoScreen;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.sorting.DimensionSorting;
import com.chaosthedude.naturescompass.sorting.NameSorting;
import com.chaosthedude.naturescompass.sorting.SourceSorting;
import com.chaosthedude.naturescompass.sorting.TagsSorting;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeSearchEntry
extends ObjectSelectionList.Entry<BiomeSearchEntry> {
    private final Minecraft mc;
    private final NaturesCompassScreen parentScreen;
    private final Biome biome;
    private final BiomeSearchList biomesList;
    private final String tags;
    private long lastClickTime;

    public BiomeSearchEntry(BiomeSearchList biomesList, Biome biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.parentScreen = biomesList.getParentScreen();
        this.mc = Minecraft.m_91087_();
        this.tags = BiomeUtils.getBiomeTags(this.parentScreen.level, biome);
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int par6, int par7, boolean par8, float par9) {
        String tagsLine;
        String title = this.parentScreen.getSortingCategory().getLocalizedName();
        Object value = this.parentScreen.getSortingCategory().getValue(this.biome);
        if (this.parentScreen.getSortingCategory() instanceof NameSorting || this.parentScreen.getSortingCategory() instanceof SourceSorting || this.parentScreen.getSortingCategory() instanceof TagsSorting || this.parentScreen.getSortingCategory() instanceof DimensionSorting) {
            title = I18n.m_118938_((String)"string.naturescompass.dimension", (Object[])new Object[0]);
            Optional<ResourceLocation> biomeKey = BiomeUtils.getKeyForBiome(this.parentScreen.level, this.biome);
            value = biomeKey.isPresent() ? BiomeUtils.dimensionKeysToString(NaturesCompass.dimensionKeysForAllowedBiomeKeys.get((Object)biomeKey.get())) : "";
        }
        if (this.mc.f_91062_.m_92895_(tagsLine = I18n.m_118938_((String)"string.naturescompass.tags", (Object[])new Object[0]) + ": " + this.tags) > this.biomesList.m_5759_()) {
            tagsLine = this.mc.f_91062_.m_92834_(tagsLine + "...", this.biomesList.m_5759_()) + "...";
        }
        guiGraphics.m_280430_(this.mc.f_91062_, (Component)Component.m_237113_((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)), left + 1, top + 1, 0xFFFFFF);
        Font font = this.mc.f_91062_;
        MutableComponent mutableComponent = Component.m_237113_((String)(title + ": " + value));
        Objects.requireNonNull(this.mc.f_91062_);
        guiGraphics.m_280430_(font, (Component)mutableComponent, left + 1, top + 9 + 3, 0x808080);
        Font font2 = this.mc.f_91062_;
        MutableComponent mutableComponent2 = Component.m_237113_((String)tagsLine);
        Objects.requireNonNull(this.mc.f_91062_);
        guiGraphics.m_280430_(font2, (Component)mutableComponent2, left + 1, top + 9 + 14, 0x808080);
        Font font3 = this.mc.f_91062_;
        MutableComponent mutableComponent3 = Component.m_237115_((String)"string.naturescompass.source").m_7220_((Component)Component.m_237113_((String)(": " + BiomeUtils.getBiomeSource(this.parentScreen.level, this.biome))));
        Objects.requireNonNull(this.mc.f_91062_);
        guiGraphics.m_280430_(font3, (Component)mutableComponent3, left + 1, top + 9 + 25, 0x808080);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.biomesList.selectBiome(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.searchForBiome();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }
        return false;
    }

    public void searchForBiome() {
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.parentScreen.searchForBiome(this.biome);
    }

    public void viewInfo() {
        this.mc.m_91152_((Screen)new BiomeInfoScreen(this.parentScreen, this.biome));
    }

    public Component m_142172_() {
        return Component.m_237113_((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome));
    }
}

