/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.common.tools.BiMap;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.config.ConfigSerializer;
import io.github.kosmx.emotes.server.serializer.BiMapSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.logging.Level;

public class Serializer {
    public static Gson serializer;
    public static Serializer INSTANCE;

    public Serializer() {
        this.initializeSerializer();
    }

    public void initializeSerializer() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        this.registerTypeAdapters(builder);
        serializer = builder.create();
    }

    protected void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(SerializableConfig.class, (Object)new ConfigSerializer());
        builder.registerTypeAdapter(new TypeToken<BiMap<UUID, UUID>>(){}.getType(), (Object)new BiMapSerializer());
    }

    public static void saveConfig() {
        Serializer.saveConfig(EmoteInstance.config);
    }

    public static void saveConfig(SerializableConfig config) {
        try {
            BufferedWriter writer = Files.newBufferedWriter(EmoteInstance.instance.getConfigPath(), new OpenOption[0]);
            serializer.toJson((Object)config, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static SerializableConfig getConfig() {
        return INSTANCE.readConfig(EmoteInstance.instance.getConfigPath());
    }

    protected SerializableConfig readConfig(Path path) {
        if (path.toFile().isFile()) {
            SerializableConfig serializableConfig;
            block10: {
                BufferedReader reader = Files.newBufferedReader(path);
                try {
                    serializableConfig = this.readConfig(reader);
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonParseException | IOException e) {
                        EmoteInstance.instance.getLogger().log(Level.WARNING, "Failed to read config: " + e.getMessage(), true);
                        EmoteInstance.instance.getLogger().log(Level.WARNING, "If you want to regenerate the config, delete the old files!", true);
                        e.printStackTrace();
                    }
                }
                reader.close();
            }
            return serializableConfig;
        } else {
            SerializableConfig config = this.readConfig((BufferedReader)null);
            Serializer.saveConfig(config);
            return config;
        }
        return this.readConfig((BufferedReader)null);
    }

    protected SerializableConfig readConfig(BufferedReader reader) throws JsonSyntaxException, JsonIOException {
        if (reader != null) {
            SerializableConfig config = (SerializableConfig)serializer.fromJson((Reader)reader, SerializableConfig.class);
            if (config == null) {
                throw new JsonParseException("Json is empty");
            }
            return config;
        }
        return new SerializableConfig();
    }
}

