/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.events.server;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.impl.event.Event;
import dev.kosmx.playerAnim.core.impl.event.EventResult;
import java.util.UUID;

public final class ServerEmoteEvents {
    public static final Event<EmoteVerifier> EMOTE_VERIFICATION = new Event(EmoteVerifier.class, listeners -> (emote, userID) -> {
        for (EmoteVerifier listener : listeners) {
            EventResult result = listener.verify(emote, userID);
            if (result != EventResult.FAIL && result != EventResult.CONSUME) continue;
            return result;
        }
        return EventResult.PASS;
    });
    public static final Event<EmotePlayEvent> EMOTE_PLAY = new Event(EmotePlayEvent.class, listeners -> (emote, userID) -> {
        for (EmotePlayEvent listener : listeners) {
            listener.onEmotePlay(emote, userID);
        }
    });
    public static final Event<EmoteStopEvent> EMOTE_STOP_BY_USER = new Event(EmoteStopEvent.class, listeners -> (emoteID, userID) -> {
        for (EmoteStopEvent listener : listeners) {
            listener.onStopEmote(emoteID, userID);
        }
    });

    @FunctionalInterface
    public static interface EmoteStopEvent {
        public void onStopEmote(UUID var1, UUID var2);
    }

    @FunctionalInterface
    public static interface EmotePlayEvent {
        public void onEmotePlay(KeyframeAnimation var1, UUID var2);
    }

    @FunctionalInterface
    public static interface EmoteVerifier {
        public EventResult verify(KeyframeAnimation var1, UUID var2);
    }
}

