/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.networking.PacketGenderInfo;
import com.wildfire.main.networking.PacketSendGenderInfo;
import com.wildfire.main.networking.PacketSync;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class WildfireSync {
    private static final String PROTOCOL_VERSION = "2";
    private static final Predicate<String> ACCEPTED_VERSIONS = NetworkRegistry.acceptMissingOr((String)"2");
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)WildfireGender.rl("main_channel")).clientAcceptedVersions(ACCEPTED_VERSIONS).serverAcceptedVersions(ACCEPTED_VERSIONS).networkProtocolVersion(() -> "2").simpleChannel();

    public static void setup(FMLCommonSetupEvent event) {
        NETWORK.registerMessage(1, PacketSync.class, PacketGenderInfo::encode, PacketSync::new, PacketSync::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(2, PacketSendGenderInfo.class, PacketGenderInfo::encode, PacketSendGenderInfo::new, PacketSendGenderInfo::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void sendToOtherClients(ServerPlayer toSync, GenderPlayer genderPlayer) {
        if (genderPlayer != null && toSync.m_20194_() != null && !(toSync instanceof FakePlayer)) {
            NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> toSync), (Object)new PacketSync(genderPlayer));
        }
    }

    public static void sendToClient(ServerPlayer sendTo, GenderPlayer toSync) {
        if (!(sendTo instanceof FakePlayer)) {
            WildfireSync.sendPacketToClient(sendTo, new PacketSync(toSync));
        }
    }

    public static void sendToServer(GenderPlayer plr) {
        if (plr != null && plr.needsSync) {
            NETWORK.sendToServer((Object)new PacketSendGenderInfo(plr));
            plr.needsSync = false;
        }
    }

    private static void sendPacketToClient(ServerPlayer sendTo, PacketSync packet) {
        if (!(sendTo instanceof FakePlayer)) {
            NETWORK.send(PacketDistributor.PLAYER.with(() -> sendTo), (Object)packet);
        }
    }
}

