/*
 * Decompiled with CFR 0.152.
 */
package oros.sereneseasonsfix.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import oros.sereneseasonsfix.SeasonUtilities;
import oros.sereneseasonsfix.data.SeasonExtraSavedData;
import sereneseasons.config.ServerConfig;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SeasonTimeCommands {
    @SubscribeEvent
    public static void onCommandsRegistered(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"season").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"time").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"info").executes(ctx -> {
            ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
            return SeasonTimeCommands.infoSeasonTime((CommandSourceStack)ctx.getSource(), (Level)world);
        }))).then(Commands.m_82127_((String)"sync").executes(ctx -> {
            ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
            return SeasonTimeCommands.syncSeasonTime((CommandSourceStack)ctx.getSource(), (Level)world);
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"time", (ArgumentType)TimeArgument.m_113037_()).executes(ctx -> {
            ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
            return SeasonTimeCommands.setSeasonTime((CommandSourceStack)ctx.getSource(), (Level)world, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time"));
        })))).then(Commands.m_82127_((String)"set_start").then(Commands.m_82129_((String)"time", (ArgumentType)TimeArgument.m_113037_()).executes(ctx -> {
            ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
            return SeasonTimeCommands.setSeasonStartTime((CommandSourceStack)ctx.getSource(), (Level)world, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time"));
        })))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"time", (ArgumentType)TimeArgument.m_113037_()).executes(ctx -> {
            ServerLevel world = ((CommandSourceStack)ctx.getSource()).m_81372_();
            return SeasonTimeCommands.addSeasonTime((CommandSourceStack)ctx.getSource(), (Level)world, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time"));
        })))));
    }

    private static int infoSeasonTime(CommandSourceStack cs, Level world) throws CommandRuntimeException {
        SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((Level)world);
        SeasonExtraSavedData seasonExtraData = SeasonExtraSavedData.getExtraSeasonSavedData(world);
        int seasonTime = seasonData.seasonCycleTicks;
        int startSeasonTime = seasonExtraData.startingSeasonCycleTicks;
        long dayTime = world.m_6106_().m_6792_();
        long delta = SeasonUtilities.calculateCycleTicks((long)seasonTime - dayTime - (long)startSeasonTime);
        cs.m_288197_(() -> {
            boolean whitelisted = ServerConfig.isDimensionWhitelisted((ResourceKey)world.m_46472_());
            return Component.m_237110_((String)"commands.sereneseasonsfix.time.info", (Object[])new Object[]{seasonTime, startSeasonTime, dayTime, delta, whitelisted});
        }, true);
        return (int)delta;
    }

    private static int syncSeasonTime(CommandSourceStack cs, Level world) throws CommandRuntimeException {
        if (SeasonUtilities.isWorldWhitelisted(world)) {
            SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((Level)world);
            SeasonExtraSavedData seasonExtraData = SeasonExtraSavedData.getExtraSeasonSavedData(world);
            SeasonUtilities.setSeasonCycleTicks(seasonData, world.m_6106_().m_6792_() + (long)seasonExtraData.startingSeasonCycleTicks);
            SeasonHandler.sendSeasonUpdate((Level)world);
            cs.m_288197_(() -> Component.m_237115_((String)"commands.sereneseasonsfix.time.sync_season.success"), true);
            return seasonData.seasonCycleTicks;
        }
        cs.m_288197_(() -> Component.m_237115_((String)"commands.sereneseasonsfix.time.sync_season.not_whitelisted"), true);
        return -1;
    }

    private static int setSeasonTime(CommandSourceStack cs, Level world, int time) throws CommandRuntimeException {
        if (SeasonUtilities.isWorldWhitelisted(world)) {
            SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((Level)world);
            SeasonUtilities.setSeasonCycleTicks(seasonData, time);
            SeasonHandler.sendSeasonUpdate((Level)world);
            cs.m_288197_(() -> Component.m_237110_((String)"commands.sereneseasonsfix.time.set_season.success", (Object[])new Object[]{seasonData.seasonCycleTicks}), true);
            return seasonData.seasonCycleTicks;
        }
        cs.m_288197_(() -> Component.m_237115_((String)"commands.sereneseasonsfix.time.set_season.not_whitelisted"), true);
        return -1;
    }

    private static int addSeasonTime(CommandSourceStack cs, Level world, int time) throws CommandRuntimeException {
        if (SeasonUtilities.isWorldWhitelisted(world)) {
            SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((Level)world);
            SeasonUtilities.setSeasonCycleTicks(seasonData, seasonData.seasonCycleTicks + time);
            SeasonHandler.sendSeasonUpdate((Level)world);
            cs.m_288197_(() -> Component.m_237110_((String)"commands.sereneseasonsfix.time.set_season.success", (Object[])new Object[]{seasonData.seasonCycleTicks}), true);
            return seasonData.seasonCycleTicks;
        }
        cs.m_288197_(() -> Component.m_237115_((String)"commands.sereneseasonsfix.time.set_season.not_whitelisted"), true);
        return -1;
    }

    private static int setSeasonStartTime(CommandSourceStack cs, Level world, int time) throws CommandRuntimeException {
        if (SeasonUtilities.isWorldWhitelisted(world)) {
            SeasonExtraSavedData seasonExtraData = SeasonExtraSavedData.getExtraSeasonSavedData(world);
            SeasonUtilities.setSeasonStartCycleTicks(seasonExtraData, time);
            SeasonHandler.sendSeasonUpdate((Level)world);
            cs.m_288197_(() -> Component.m_237110_((String)"commands.sereneseasonsfix.time.set_season_start.success", (Object[])new Object[]{seasonExtraData.startingSeasonCycleTicks}), true);
            return seasonExtraData.startingSeasonCycleTicks;
        }
        cs.m_288197_(() -> Component.m_237115_((String)"commands.sereneseasonsfix.time.set_season_start.not_whitelisted"), true);
        return -1;
    }
}

